;CW KEYBOARD v3.0  04-FEB-2004
;
;Babushkin Anton RK3DOV
;	mailto:rk3dov@mail.ru
;	http://www.qsl.net/rk3dov

;*** INITSPD - initial speed. You may correct this value.

.equ INITSPD=15

;============================================================================
.include "2323def.inc"

;RESERVED	=r0
.def dech	=r1
.def decl	=r2
.def tm		=r3
.def spd	=r4
.def shift	=r5
.def sregold	=r6
.def count	=r7
.def ext	=r8
.def prob	=r9
.def ti		=r10
.def rus	=r11
.def tz		=r12
;---------------------
.def i		=r16
.def s		=r17
.def fifol	=r18
.def fifoh	=r19
.def mod	=r20
.def t		=r21
.def b		=r22
.def q		=r23

.def bufh	=r26	;X
;RESERVED	=r27

.def bufg	=r28	;Y
;RESERVED	=r29

;RESERVED	=r30	Z
;RESERVED	=r31


.equ buflo=0x60
.equ bufhi=0xD0

.org 0
	rjmp init

.org OVF0addr
	rjmp timeint	;TIMER

.include "interrupt.asm"
.include "insmacro.asm"
.include "nr.asm"
.include "outbuf.asm"
.include "keytable.inc"

;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

init:	ldi t,RAMEND   ; 
	out spl,t

	clr count
	clr rus
	clr ext
	clr mod
	clr prob
	clr fifol
	clr fifoh
	clr shift
	clr XH
	clr YH
	clr ZH
	clr ZL
	ldi bufg,buflo
	ldi bufh,buflo

	ldi t,INITSPD
	mov spd,t

	clr b
	mov dech,b
	inc b
	mov decl,b

	ldi t,3
	out TCCR0,t	; 
	
	ldi t,2
	out TIMSK,t

	ldi t,4
	out DDRB,t

	ldi t,3
	out PORTB,t
	
start:

.include "rx.asm"

;HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH>>>>>>>>>>>>>>>>>>>>>>
;		  
		;b - HAW bytic
;--------------------------------
;====================================================================
	ldi t,1
	cp ext,t	;key up
	brne ext0
		;--------------
		clr ext

	    	cpi b,0x12		;shift UP
	    	brne shiftup1
			;--------------
			clr shift
			rjmp start
			;--------------
shiftup1:	cpi b,0x59		;shift UP
		brne notshift
			;--------------
			clr shift
			rjmp start
			;--------------

notshift:	rjmp start	;  -  SHIFT
		;-----------------
;====================================================================
ext0:	ldi t,2
	cp ext,t	; ext codes,   E0:
	brne ext1
		;-----------------
		clr ext
				;Change speed
		cpi b,0x7D	;PageDwn -
		brne chngspd1
			;-----------------
			dec spd
			rjmp start
			;-----------------

chngspd1:	cpi b,0x7A	;PageUp +
		brne ext1
			;-----------------
			inc spd
			rjmp start
			;-----------------
		;-----------------

;====================================================================
ext1:	cpi b,0xf0	;key up
	brne ext2
		;-----------------KEY UP---------------
		ldi t,1
		mov ext,t
		rjmp start
		;-----------------
;====================================================================
ext2:	cpi b,0xE0	;-------  extCODE
	brne shift0
		;-----------------
		ldi t,2
		mov ext,t
		rjmp start
		;-----------------
;====================================================================
;====================================================================
;====================================================================
shift0:	cpi b,0x12	; shift
	brne shift1
		;-----------------
		ldi t,1
		mov shift,t
		rjmp start
		;-----------------

shift1:	cpi b,0x59	; shift
	brne shift2
		;-----------------
		ldi t,1
		mov shift,t
		rjmp start
		;-----------------

;====================================================================
shift2:	clr t		;with SHIFT
	cp shift,t
	breq ctl0
		;-----------------
		cpi b,0x4A	;?       Shift'om
		brne shift3
			;-----------------
			ldi b,0x48
			rjmp mc1
			;-----------------

shift3:		cpi b,0x55	;+
		brne shift4
			;-----------------
			ldi b,0x56
			rjmp mc1
			;-----------------

shift4:		cpi b,0x41	;<
		brne ctl0
			;-----------------
			ldi b,0x40
			rjmp mc1
			;-----------------

;====================================================================
;=======================   ==============================
			;CapsLock - RUS/ENG
ctl0:	cpi b,0x58
	brne mc0
		;-----------------
		inc rus
		ldi t,1
		and rus,t
		rjmp start
		;-----------------

;====================================================================

.include "macro.asm"

ctl1:			;ESC - CLEAR BUFFER
	cpi b,0x76
	brne n20
		;-----------------
		ldi fifol,0
		ldi fifoh,0
		mov bufh,bufg
		rjmp start
		;-----------------


n20:	;---------------OBICHNAJA KNOPKA--------
	ldi t,0
	cp rus,t
	breq langen
	ori b,0x80
langen:
	mov t,b
	rcall outbuf

	rjmp start
