;==================================================================
;       
; .    ATtiny 15.  -  . . 
;25.10.2008.
;==================================================================
.INCLUDE "TN15DEF.INC"
.DEF  D10=R0    ;Register for tenth right Digit 
.DEF  D9=R1
.DEF  D8=R2
.DEF  D7=R3
.DEF  D6=R4
.DEF  D5=R5
.DEF  D4=R6
.DEF  D3=R7
.DEF  D2=R8     ;Register for second  Digit 
.DEF  D1=R9     ;Register for first left Digit 
.EQU  DI=PB0    ;Constant for Data Indicator pin 
.ORG  000       ;Reset Vector
RJMP  RESET     
;******************************************************************
;Interrupt on complete Analog-Digital Conversion 
;******************************************************************
.ORG  0x0008    ;Interrupt Vector - ADC Complete
IN    R24,SREG  ;Save Status Register in Time the interrupt works
IN    R20,ADCL  ;Read  
IN    R21,ADCH  ;Data ADC
LSR   R21       ;10 bit data ADC convert to 9 bits
ROR   R20       ;(low bit is ignored)
CP    R20,R26   ;If Data ADC is less minimum Voltage
CPC   R21,D9
BRLO  OFF       ;setup, Power - offline
CP    R20,R27   ;If Data ADC is more maximum Voltage 
CPC   R21,D9
BRSH  OFF       ;setup, Power - offline
RJMP  END       ;Otherwise - start ADC and exit Interrupt
OFF: 
OUT   TCCR1,D4
OUT   TCNT1,D4
CBI   PORTB,1
LDI   R31,7
MOV   D10,R31   ;Timer Counter 1 stop is 7 seconds (Power-offline)
CLR   R31
END:
SBI   ADCSR,6   ;Start ADC
OUT   SREG,R24  ;Returned Status Register
RETI            ;Exit Interrupt
;******************************************************************
;Initial Setups
;******************************************************************
RESET:
CLR   D4
CLR   D9
LDI   R26,160
LDI   R27,230
LDI   R16,3
OUT   DDRB,R16
LDI   R16,2     ;Selection Input ADC and basic Voltage: 
OUT   ADMUX,R16 ;Basic Voltage - VCC,Input ADC-PB3.Data=10 bit
LDI   R16,	236    
OUT   ADCSR,R16
LDI   R16,10
MOV   R10,R16
SBI   PORTB,2
SBI   PORTB,4
LDI   R16,160   ;Frequency T\C1 - 10 000 Hz
OUT   OCR1B,R16
LDI   R16,144   ;Factor of filling 0,1
OUT   OCR1A,R16
SEI
;******************************************************************
;Main Program begin
;******************************************************************
START:
MOV   R17,R20
MOV   R18,R21
LDI   R19,100
CLR   R22
RCALL DIV
TST   R15
BRNE  PC+2
MOV   R15,R10 
MOV   R13,R15
LDI   R19,10
CLR   R22
RCALL DIV
TST   R15
BRNE  PC+2
MOV   R15,R10
MOV   R12,R15
TST   R17
BRNE  PC+2
MOV   R17,R10
MOV   D1,R17
SCAN:
SBIS  PINB,4
RJMP  MIN
SBIS  PINB,2
RJMP  MAX
RJMP  DD
MIN:
CPI   R26,210
BREQ  PC+3
SUBI  R26,-5
RJMP  DD1
LDI   R26,160
RJMP  DD1
MAX:
CPI   R27,255
BREQ  PC+3
SUBI  R27,-5
RJMP  DD2
LDI   R27,230
RJMP  DD2
DD:
INC   R29
SBRS  R29,0
RJMP  DD1
RJMP  DD2
DD1:
MOV   R17,R26
RJMP  PC+2
DD2:
MOV   R17,R27
CLR   R18
LDI   R19,100
CLR   R22
RCALL DIV
MOV   D8,R15
LDI   R19,10
RCALL DIV
TST   R15
BRNE  PC+2
MOV   R15,R10
MOV   D7,R15
TST   R17
BRNE  PC+2
MOV   R17,R10
MOV   D6,R17
;******************************************************************
LCD:  
CLR   D5
MOV   D3,R13
MOV   D2,R12
LDI   R16,10
CLR   ZL
IND:  
LD    R11,Z
SWAP  R11
LDI   R23,4
IND1: 
ROL   R11
SBI   PORTB,DI
BRCC  PC+4
LDI   R25,35
DEC   R25
BRNE  PC-1
NOP
NOP
NOP
NOP
NOP
CBI   PORTB,DI
LDI   R25,35
DEC   R25
BRNE  PC-1
DEC   R23
BRNE  IND1
INC   ZL
DEC   R16
BRNE  IND
;******************************************************************
PAUSE:
LDI   R28,5
RCALL PP
DEC   R25
BRNE  PC-2
DEC   R28
BRNE  PC-4
IN    R16,TCCR1
CPI   R16,0     ;If T\C1 is stopped,
BREQ  PC+2      ;decrement Time
RJMP  START     ;Otherwise go tu the label "START"
DEC   D10       ;If 7 second Interval no has expired,
BRNE  PC+3      ;go to the label "START"
LDI   R25,117
OUT   TCCR1,R25 ;Start T\C1 (Power - online)
RJMP  START
;******************************************************************
; Subroutine of division
DIV:  
CLR   R15
LOOP: 
CP    R17,R19
CPC   R18,R22
BRLO  EX
INC   R15
SUB   R17,R19
SBC   R18,R22
RJMP  LOOP
EX:   RET
;******************************************************************
PP:   
DEC   R5
BRNE  PP
RET
.EXIT

