;************************************************************
;   "⮢ ". ୠ "" N XX  2002 .  *
;************************************************************
;   Filename:		hedgehog.asm			    *
;   First Date:		11 November 1997		    *
;   Last  Date:		24 Februari 2002		    *
;   File Version:	1.02				    *
;   Assembler:		mpasm 1.40			    *
;   Author:		Bogdanov Andrew			    *
;   E-Mail:		BrSoft@tsrv.ru			    *
;************************************************************
; 頥  ᯮ짮  	 ᪨  楫.	    *
;  ணࠬ	।祭  饭 ઠ쭮	    *
; 誨	 ᢥ⮢ ਡ 㯯 Flower.  ०	    *
; ࠡ -  ணࠬ	    ७ 䮭.	    *
;							    *
;	Pin 7  (GPIO 0)	-->  ४⥫ ணࠬ-   *
;			     0=ணࠬ   1=	    *
;	Pin 6  (GPIO 1)	-->   뢮 Y1    \ᨭ\	    *
;	Pin 5  (GPIO 2)	-->   뢮 Y2    \\	    *
;	Pin 4  (GPIO 3)	-->  室   㪠 (to high)  *
;	Pin 3  (GPIO 4)	-->   뢮 Y3    \\    *
;	Pin 2  (GPIO 5)	-->   뢮 Y4    \\    *
;							    *
;************************************************************
    LIST    p=12C508	; PIC12C508 is the target processor *
  __CONFIG  b'111111101110'	    ;			    *
; osc=intrc(F⠪=4Mhz),    wdte=on,   cp=off,	 mclre=off  *
;************************************************************
;	M						    *
;************************************************************
cmp	macro	metka1,metka2	   ; ࠢ 1  2	    *
	movf	metka2,w	   ;			    *
	subwf	metka1,w	   ;			    *
	endm			   ;  	    *
mov	macro	metka1,metka2	   ; 뫪 2->1	    *
	movf	metka2,w	   ;			    *
	movwf	metka1		   ;			    *
	endm			   ;  	    *
mvi	macro	metka1,constant	   ; 뫪 constant->1 *
	movlw	constant	   ;			    *
	movwf	metka1		   ;			    *
	endm			   ;  	    *
jnz	macro	metka		   ; ᫮ 室	    *
	btfss	Status,2	   ; ᫨ -  = 0	    *
	goto	metka		   ;			    *
	endm			   ;  	    *
jz	macro	metka		   ; ᫮ 室	    *
	btfsc	Status,2	   ; ᫨ - = 0	    *
	goto	metka		   ;			    *
	endm			   ;  	    *
jnc	macro	metka		   ; ᫮ 室	    *
	btfss	Status,0	   ; ᫨ A > B		    *
	goto	metka		   ;			    *
	endm			   ;  	    *
jc	macro	metka		   ; ᫮ 室	    *
	btfsc	Status,0	   ; ᫨ A < B		    *
	goto	metka		   ;			    *
	endm			   ;  	    *
;************************************************************
;	    Bit	Definitions				    *
;************************************************************
CR	 equ	0	; Carry				    *
ZR	 equ	2	; Zero				    *
W	 equ	0	;   	    *
F	 equ	1	;   ॣ		    *
RP0	 equ	5	; ࠭			    *
;************************************************************
b_stop	 equ	0	; (mode) - ⮯=0 =1	    *
b_direct equ	1	; (mode) -  - ࠢ	    *
b_wait	 equ	2	; (mode) -  	    *
b_choise equ	3	; (mode) - 롮 ⨯ 饭	    *
b_wrStop equ	4	; (mode) - ⠭a 	᫥.   *
;************************************************************
in_musik equ	3	; (port) - 室	  䮭  *
switcher equ	0	; (port) - ४. musik-programma  *
;************************************************************
;	    Register Definitions			    *
;************************************************************
Timer	 equ   01h    ;	७ ⠩		    *
PC	 equ   02h    ;	稪				    *
Status	 equ   03h    ;	 ॣ		    *
GPIO	 equ   06h    ;	 -뢮		    *
;************************************************************
mode	 equ   0Eh    ;	ᬮ ᠭ			    *
polustep equ   0Fh    ;	蠣	 楤 slowly	    *
job	 equ   10h    ;	 ᯮ塞  ⠡.     *
adr_job	 equ   11h    ;	⥪騩	 		    *
speed	 equ   12h    ;	᪮ ઠ (30 = 58hz)	    *
count_s	 equ   13h    ;	ઠo	 稪	    *
count_z	 equ   14h    ;	ઠo	.			    *
step_zer equ   15h    ;	ઠo	蠣			    *
stone	 equ   16h    ;	蠣 	 饭	    *
sqw	 equ   17h    ;	᪢   饭   *
count_p	 equ   18h    ;	LowBait	     প ᫥	    *
count_p2 equ   19h    ;	HiBait	     祧 㪠	    *
count_m	 equ   1Ah    ;	LowBait	(music)	প 	    *
count_m2 equ   1Bh    ;	HiBait	᪥ ᨫ쭮 	    *
count_r	 equ   1Ch    ;	LowBait	   প 	ࠡ	    *
count_r2 equ   1Dh    ;	HiBait	    ணࠬ		    *
temp_1	 equ   1Fh    ;	६,⮫쪮   楤  *
;************************************************************
;	    Constant Definitions			    *
;************************************************************
const_p	  equ	d'120' ; ᫥ . 모		    *
const_r	  equ	d'55'  ;  ࠡ ணࠬ		    *
const_m	  equ	d'26'  ;  ᪥ ᨫ쭮 	    *
const_sqw equ	d'64'  ; ਡ 蠣 猪	    *
;************************************************************
	org	0x00
	goto	Start  ; 室  砫 ணࠬ
;************************************************************
Tabs		       ; 砫	⠡
;************************************************************
comTable ; 室	W =    0  127 (7 .)
;************************************************************
	    addwf      PC,F	   ; W + PC -> PC
; Oᠭ  :
;  = 0  - c⮯
;  = 1  - 	饭 (ࠢ -	⭮)
;  >= 2 - 蠣	饭:
;	   ᫠ -  \  - ࠢ
;	  ᪮: 2-3=20hz, 4-5=30hz,	6-7=40hz
;		    8-9=50hz, 10-11=60hz
; 	>= 16  ணࠬ
;--0----------------------------------------------------------
	    retlw      d'08'; 0	 ᠭ :
	    retlw      d'09'; 1	 4-ࠧ	 -	ࠢ
	    retlw      d'08'; 2	 ᪮ - 50 hz
	    retlw      d'09'; 3	      3	= 20hz
	    retlw      d'08'; 4	      5	= 30hz
	    retlw      d'09'; 5	      7	= 40hz
	    retlw      d'08'; 6	      9	= 50hz
	    retlw      d'03'; 7	     11	= 60hz
; --1---------------------------------------------------------
	    retlw      d'01'; 0	 ᠭ :
	    retlw      d'01'; 1	  ᪮
	    retlw      d'01'; 2	  	஭
	    retlw      d'01'; 3	  祭 8 ਮ
	    retlw      d'01'; 4
	    retlw      d'01'; 5
	    retlw      d'01'; 6
	    retlw      d'01'; 7
; --2---------------------------------------------------------
	    retlw      d'06'; 0	 ᠭ  :
	    retlw      d'06'; 1	 4-ࠧ	
	    retlw      d'07'; 2	 4-ࠧ	ࠢ
	    retlw      d'07'; 3	 ᪮ - 40 hz
	    retlw      d'06'; 4	  ய᪠
	    retlw      d'06'; 5	 १ 1 
	    retlw      d'07'; 6
	    retlw      d'07'; 7
	    retlw      d'06'; 0
	    retlw      d'06'; 1
	    retlw      d'07'; 2
	    retlw      d'07'; 3
	    retlw      d'06'; 4
	    retlw      d'06'; 5
	    retlw      d'07'; 6
	    retlw      d'07'; 7
; --4---------------------------------------------------------
	    retlw      d'08'; 0	 ᠭ :
	    retlw      d'09'; 1	 4-ࠧ	
	    retlw      d'08'; 2	 4-ࠧ	ࠢ
	    retlw      d'09'; 3	 ᪮ - 50 hz
	    retlw      d'08'; 4
	    retlw      d'09'; 5
	    retlw      d'08'; 6
	    retlw      d'09'; 7
; --5---------------------------------------------------------
	    retlw      d'04'; 0	 ᠭ  :
	    retlw      d'04'; 1	 4-ࠧ	
	    retlw      d'04'; 2	 4-ࠧ	ࠢ
	    retlw      d'04'; 3	 ᪮ - 30 hz
	    retlw      d'05'; 4	  ய᪠
	    retlw      d'05'; 5	 १ 2 
	    retlw      d'05'; 6	  3-
	    retlw      d'05'; 7
	    retlw      d'04'; 0	 ᠭ :
	    retlw      d'04'; 1
	    retlw      d'04'; 2
	    retlw      d'04'; 3
	    retlw      d'05'; 4
	    retlw      d'05'; 5
	    retlw      d'05'; 6
	    retlw      d'00'; 7
; --7---------------------------------------------------------
	    retlw      d'07'; 0	 ᠭ :
	    retlw      d'00'; 1	 -⮯ १	ࠧ
	    retlw      d'06'; 2	 ᪮ - 40 hz
	    retlw      d'00'; 3
	    retlw      d'07'; 4
	    retlw      d'00'; 5
	    retlw      d'06'; 6
	    retlw      d'00'; 7
;---8---------------------------------------------------------
	    retlw      d'07'; 0	 ᠭ :
	    retlw      d'00'; 1	 -⮯ १	ࠧ
	    retlw      d'06'; 2	 ᪮ - 40 hz
	    retlw      d'00'; 3
	    retlw      d'07'; 4
	    retlw      d'00'; 5
	    retlw      d'06'; 6
	    retlw      d'03'; 7
; --9---------------------------------------------------------
	    retlw      d'01'; 0	 ᠭ :
	    retlw      d'01'; 1	  ᪮
	    retlw      d'01'; 2	  	஭
	    retlw      d'01'; 3	  祭 8 ᮢ
	    retlw      d'01'; 4
	    retlw      d'01'; 5
	    retlw      d'01'; 6
	    retlw      d'01'; 7
; --10--------------------------------------------------------
	    retlw      d'03'; 0	 ᠭ  :
	    retlw      d'06'; 1	 4-ࠧ	
	    retlw      d'07'; 2	 4-ࠧ	ࠢ
	    retlw      d'07'; 3	 ᪮ - 40 hz
	    retlw      d'06'; 4	  ய᪠
	    retlw      d'06'; 5	 १ 1 
	    retlw      d'07'; 6
	    retlw      d'07'; 7
	    retlw      d'06'; 0
	    retlw      d'06'; 1
	    retlw      d'07'; 2
	    retlw      d'07'; 3
	    retlw      d'06'; 4
	    retlw      d'06'; 5
	    retlw      d'07'; 6
	    retlw      d'07'; 7
; --12--------------------------------------------------------
	    retlw      d'08'; 0	 ᠭ :
	    retlw      d'09'; 1	 4-ࠧ	
	    retlw      d'08'; 2	 4-ࠧ	ࠢ
	    retlw      d'09'; 3	 ᪮ - 50 hz
	    retlw      d'08'; 4
	    retlw      d'09'; 5
	    retlw      d'08'; 6
	    retlw      d'09'; 7
; --13--------------------------------------------------------
	    retlw      d'06'; 0	 ᠭ  :
	    retlw      d'06'; 1	 4-ࠧ	
	    retlw      d'07'; 2	 4-ࠧ	ࠢ
	    retlw      d'07'; 3	 ᪮ - 40 hz
	    retlw      d'06'; 4	  ய᪠
	    retlw      d'06'; 5	 १ 1 
	    retlw      d'07'; 6
	    retlw      d'07'; 7
	    retlw      d'06'; 0
	    retlw      d'06'; 1
	    retlw      d'07'; 2
	    retlw      d'07'; 3
	    retlw      d'06'; 4
	    retlw      d'06'; 5
	    retlw      d'07'; 6
	    retlw      d'07'; 7
; --15--------------------------------------------------------
	    retlw      d'08'; 0	 ᠭ :
	    retlw      d'08'; 1	 -⮯ १	ࠧ
	    retlw      d'09'; 2	 ᪮ - 50 hz
	    retlw      d'09'; 3
	    retlw      d'08'; 4
	    retlw      d'09'; 5
	    retlw      d'08'; 6
	    retlw      d'09'; 7
;*************************************************************
speedTable  ; ᮮ⭮襭   ᪮
;*************************************************************
	    addwf      PC,F	   ; W + PC -> PC
	    retlw      d'99'	   ; 0 - stop
	    retlw      d'99'	   ; 1 - slowly
	    retlw      d'90'	   ; 2 - 20 hz !
	    retlw      d'90'	   ; 3 - 20 hz !
	    retlw      d'60'	   ; 4 - 30 hz
	    retlw      d'60'	   ; 5 - 30 hz
	    retlw      d'45'	   ; 6 - 40 hz
	    retlw      d'45'	   ; 7 - 40 hz
	    retlw      d'35'	   ; 8 - 50 hz
	    retlw      d'35'	   ; 9 - 50 hz
	    retlw      d'30'	   ; 10	- 60 hz	!
	    retlw      d'30'	   ; 11	- 60 hz	!
	    retlw      d'25'	   ; 12	- 70 hz	!
	    retlw      d'25'	   ; 13	- 70 hz	!
	    retlw      d'20'	   ; 14	- 80 hz	!
	    retlw      d'20'	   ; 15	- 80 hz	!
;  ⠡, 祭  '!',	 ⮩稢
; ࠡ  묨	⨯ ⥫, ⮬
; ᯮ짮  ᫥ ஦!
;*************************************************************
stepZer	 ; 室	W-	蠣 	0  3 (  1,2,4,5 )
;*************************************************************
	    addwf      PC,F	   ; W + PC -> PC
   DT  b'100100',b'100010',b'010010',b'010100'
;*************************************************************
Tabf				   ;  ⠡
;*************************************************************
 if ( (Tabs & 0x0FF) >=	(Tabf &	0x0FF) )
 MESSG "Warning: Tables crosses page boundry in computed jump"
 endif
;*************************************************************
Start				    ; Main program
;*************************************************************
	    bcf		Status,RP0  ; c࠭ 0
	    movlw	b'001001'   ; P0-in,mode  P3-in,sound
	    TRIS	GPIO	    ; P1,2,4,5 outputs motor
	    clrwdt		    ;  WDT	⠩
	    movlw	b'10000011' ; intrc/4->Presc->Timer0
	    OPTION		    ; Presc=1:16
	    mvi		mode,10h    ; ⠭	0 ० (⮯)
	    clrf	adr_job	    ; ⠭	0  
	    clrf	count_z	    ; ઠ	 | 
	    clrf	count_s	    ; ..	 | 稪
	    clrf	count_p2    ; ᫥饭
	    clrf	count_m2    ; প 모
	    mvi		speed,d'45' ; k=1800/hz
;*************************************************************
base_cuc:		       ; ࠡ	 ணࠬ
;*************************************************************
	clrwdt		       ;  WDT ⠩
	btfsc	GPIO,switcher  ; ஢ઠ  ४祭
	goto	mode_music     ; 몫祭, 室  .모
prog_rotor:		       ; 饭  ணࠬ
	movlw	0ffh	       ; ࠢ 稪  ⠭⮩
	subwf	count_r,w      ;
	jnc	base_timer     ;  	襫
	incf	count_r2,f     ;     	஢ ⠭
	movlw	const_r	       ; ࠢ 稪  ⠭⮩
	subwf	count_r2,w     ;
	jnc	base_timer     ;  	襫  . .
	clrf	count_r	       ; 襫,
	clrf	count_r2       ; 㫨 প
	bsf	mode,b_stop    ; ⠭ 	
	call	follow_prog    ; ࠡ⪠ ணࠬ
	goto	base_timer     ; ய ࠡ⪨ 모
; ----------------------------------------------------------------------
mode_music:		   ; ᭮ 横
	clrwdt		   ;  WDT ⠩
	call	music	   ;  	ࠡ⪠ . 
	clrwdt		   ;  WDT ⠩
	call	posle_jmp  ; 몫 饭 १ 1 ᥪ ᫥
; ----------------------------------------------------------------------
base_timer:
	btfss	 Timer,3   ;  ஢ઠ ࠧ鸞 3
	goto	 obxod_tm  ;   3=0 -> த 横
	clrf	 Timer	   ;   3=1 ->    |  ⠩
	incf	count_z,f  ; ઠ	    | 	ਡ 祭
	incf	count_s,f  ; . ᪮ | 稪	 1
	incf	count_p,f  ; ᫥饭  | 
	incf	count_m,f  ; . 모    | 稪 뢠
	incf	count_r,f  ; 	ணࠬ   | ᢮  楤ன
obxod_tm:
; ----------------------------------------------------------------------
	btfss	mode,b_stop   ;	஢ઠ ०	(0)	0-⮯,1-
	goto	base_cuc      ;	᫨ 1    ய
	btfss	mode,b_wrStop ;	䫠 ६ ⠭
	goto	base_cuc      ;		᫥. 
	btfss	mode,b_choise ;	䫠 ६ ⠭
	goto	mot_zer_      ;	0=ࠧ᪮⭮ 饭 ઠ
	clrwdt		      ;	 WDT ⠩
	call	slowly_jmp    ;	1= 饭 ઠ
	goto	base_cuc      ;	 楤
mot_zer_:
	clrwdt		      ;	 WDT ⠩
	call	mot_zer_jmp   ;	0=ࠧ᪮⭮ 饭 ઠ
	goto	base_cuc      ;	 楤
;***********************************************************************
posle_jmp:		      ;	쭨	室
	goto	posle	      ;	goto    512 ( )
slowly_jmp:		      ;	call    256 (⮫쪮 
	goto	slowly	      ;		       ࠭ ࠣ)
mot_zer_jmp:
	goto	mot_zer
;***********************************************************************
music:			     ; 	 ࠡ⪠ 몠	
;***********************************************************************
	btfsc	mode,b_wait  ; ஢ઠ	䫠  
	goto	mus_gate     ; 䫠 祭=1, 	
	movlw	0ffh	     ; 䫠 몫祭,
	subwf	count_m,w    ; ࠢ	稪	 ⠭⮩
	jnc	mus_ret	     ; 室,   襫  ஢ ⠭
	incf	count_m2,f
	movlw	const_m	     ; ࠢ	稪	 ⠭⮩
	subwf	count_m2,w   ;
	jnc	mus_ret	     ; 室,   襫  ஢ ⠭
	clrf	count_m	     ; 襫,
	clrf	count_m2     ; 㫨	প 
	bsf	mode,b_wait  ; ⠭ 䫠 (=1) 	
mus_ret:
	return
;-----------------------------------------------------------------------
mus_gate:
	btfss	GPIO,in_musik	; ஢ઠ 	?
	goto	mus_ret		;  
	bcf	mode,b_wait	; .䫠 -   室
;***********************************************************************
follow_prog:	    ; ⥫ ணࠬ 稪 
;***********************************************************************
	incf	adr_job,f	; ᫥ 
	movlw	b'01111111'	; ᪠	 訥 ࠧ
	andwf	adr_job,f	; max =	128 
	movf	adr_job,0	; 		-> W
	call	comTable	;  -> W
	andlw	0fh		; max =	16 祭
	movwf	temp_1		; ࠭ 
	call	speedTable	; ᪮ -> W
	movwf	speed		; ⠭ ᪮
	movlw	1		;
	subwf	temp_1,w	;  = 1 ?
	jnz	mus_move_1	; த
	bsf	mode,b_choise	; .  饭
mus_move_1:			;
	bcf	mode,b_choise	; . ࠧ 饭
	movlw	0		;
	subwf	temp_1,w	;  = 0 ?
	jnz	mus_move_2	; த
	bcf	mode,b_wrStop	; 䫠 ⠭  ᫥.
	return			;
mus_move_2:			;
	bsf	mode,b_wrStop	; 䫠 ⠭ - ० 
	btfss	temp_1,0	; ஢ઠ  ⭮:	-ࠢ
	goto	mus_left	; 饭 
	bsf	mode,b_direct	; 饭 ࠢ
	return			;
mus_left:			;
	bcf	mode,b_direct	; 饭 
	return			;
;*****************************************************************
mot_zer:		      ;	ଠ쭮 饭 
;*****************************************************************
	movf	speed,w	      ;	஢  co
	subwf	count_z,w     ;	⥪饣 祭 稪
	btfss	Status,CR     ;	 ⠭	᪮
	return		      ;	᫨ ᮢ,	  ய
	clrf	count_z	      ;	 稪 饭 ઠ
	btfss	mode,b_direct ;	஢ઠ ०	 0-,1-ࠢ
	goto	mot_left      ;	᫨ 0    ய
mot_right:		      ;
	incf	step_zer,f    ;	ࠢ - 蠣 
	goto	mot_job	      ;	஢稢   1 蠣
mot_left:		      ;
	decf	step_zer,f    ;	 -	蠣 
mot_job:		      ;	஢稢   1 蠣
	movlw	b'00000011'   ;	㧨 	蠣 - 4 蠣
	andwf	step_zer,w    ;	९
	call	stepZer	      ;	८ࠧ  蠣   
	movwf	GPIO	      ;	뤠  蠣  
	return		      ;
;***************************************************************
stepZermp:		      ;	쭨	室
	goto	stepZer	      ;	goto 	512	call 	256
;***************************************************************
posle:			      ;	몫 饭 १ 2 ᥪ ᫥
			      ;	ய 㪮 ᮢ
;***************************************************************
	btfss	GPIO,in_musik ;
	goto	posl_nogate   ;	஢ઠ   ?
	bsf	mode,b_stop   ;	, ⠭ ० 
	clrf	count_p	      ;	㫨 稪 訩
	clrf	count_p2      ;	㫨 稪 訩
	return		      ;
posl_nogate:		      ;	 
	movlw	0ffh	      ;	ࠢ 稪  ⠭⮩
	subwf	count_p,w     ;
	jnc	posl_ret      ;	 襫  ஢ ⠭
	incf	count_p2,f    ;
	movlw	const_p	      ;	ࠢ 稪  ⠭⮩
	subwf	count_p2,w    ;
	jnc	posl_ret      ;	 襫  ஢ ⠭
	bcf	mode,b_stop   ;	襫, ⠭ ०	
posl_ret:
	return
;*************************************************************
slowly:	 ; 饭  , 祬 릪  1 蠣.
	 ;  砥   ६ ᪢
	 ; ᮢ,   ⪨ .
;*************************************************************
	movlw	d'02'	   ; ஢  co
	subwf	count_s,w  ; ⥪饣 祭 稪
	btfss	Status,CR  ;  ⠭ ᪮
	goto	cross_v	   ; ᮢ,  ய
	clrf	count_s	   ;  稪 ⠩
	decf	polustep,f ; 㬥 稪 ᪢
	jz	newl	   ; ᫨  = 0  ⨯
	decf	polustep,f ; 㬥 稪 ᪢
	jz	newl	   ; ᫨  = 0  ⨯
	goto	cross_v	   ; ४⥫
newl:			   ;
	incf	stone,f	   ;  塞 ⨯  ४⥫
	movlw	b'00000011'; ( ⪨  )
	andwf	stone,f	   ;  譨 
cross_v:		   ;
	movlw	1	   ; ࠢ ॣ 	⠭⮩
	subwf	stone,w	   ;  室  㣮 蠣
	jz	var2	   ;
	movlw	2	   ; ࠢ ॣ 	⠭⮩
	subwf	stone,w	   ;  室  㣮 蠣
	jz	var3	   ;
	movlw	3	   ; ࠢ ॣ 	⠭⮩
	subwf	stone,w	   ;  室  㣮 蠣
	jz	var4	   ;
;-------------------------------------------------------------
var1:			      ;	1
	movlw	const_sqw     ;	롮 뢮 ᪢
	addwf	sqw,f	      ;	   ⮪ 
	cmp	sqw,polustep  ;
	jc	ust100010     ;	᫨  - 1->0
	goto	ust100100     ;	᫨  - 0->1
;-------------------------------------------------------------
var2:			      ;	2
	movlw	const_sqw     ;	롮 뢮 ᪢
	addwf	sqw,f	      ;	   ⮪ 
	cmp	sqw,polustep  ;
	jc	ust010010     ;	᫨  - 1->0
	goto	ust100010     ;	᫨  - 0->1
;-------------------------------------------------------------
var3:			      ;	3
	movlw	const_sqw     ;	롮 뢮 ᪢
	addwf	sqw,f	      ;	   ⮪ 
	cmp	sqw,polustep  ;
	jc	ust010100     ;	᫨  - 1->0
	goto	ust010010     ;	᫨  - 0->1
;-------------------------------------------------------------
var4:			      ;	4
	movlw	const_sqw     ;	롮 뢮 ᪢
	addwf	sqw,f	      ;	   ⮪ 
	cmp	sqw,polustep  ;
	jc	ust100100     ;	᫨  - 1->0
	goto	ust010100     ;	᫨  - 0->1
;-------------------------------------------------------------
ust100010:		      ;	1
     movlw b'100010'	      ;	 祭
     movwf GPIO		      ;	᪢  
     return		      ;
ust100100:		      ;	2
     movlw b'100100'	      ;	 祭
     movwf GPIO		      ;	᪢  
     return		      ;
ust010010:		      ;	3
     movlw b'010010'	      ;	 祭
     movwf GPIO		      ;	᪢  
     return		      ;
ust010100:		      ;	4
     movlw b'010100'	      ;	 祭
     movwf GPIO		      ;	᪢  
     return		      ;
;*************************************************************
;
    END

