;     ,
;        .
;    
;     .
;      
;  " ".
;      ,  
;  6-   
;(..).

;================================================================
;  .
;================================================================
.include	"tn2313DEF.inc"
;================================================================
;  .
;================================================================
;  
.equ	T_No_Task     = 0
.equ	T_Check_Button_On  = 1 ;   .
.equ	T_Check_Button_Off = 2 ;   .
;    .
.equ	S_Work_Time      = 0x01
.equ	S_Delay_Time     = 0x02
.equ	S_Set_WT_Minutes = 0x04
.equ	S_Set_WT_Seconds = 0x08
.equ	S_Set_DT_Minutes = 0x10
.equ	S_Set_DT_Seconds = 0x20
.equ	S_FULL		 = 0x40
;     .
.equ	R_Button0_Enable = 0x01
.equ	R_Button1_Enable = 0x02
;    .
.equ	Sym_Ust	= 0x3E ;""
.equ	Sym_Rab	= 0x79 ;""
.equ	Sym_Pro	= 0x75 ;""
.equ	Sym_Def	= 0x08 ;"-"
.equ	Sym_F	= 0x59 ;"F"
.equ	Sym_U	= 0x37 ;"U"
.equ	Sym_L	= 0x13 ;"L"
.equ	Sym__	= 0x00 ;" "
;    EEPROM.
.equ	EE_ADR_WT_M = 0x00
.equ	EE_ADR_WT_S = 0x10
.equ	EE_ADR_DT_M = 0x20
.equ	EE_ADR_DT_S = 0x30
;================================================================
;  .
;================================================================
;  .   
.equ	Minutes = 0x70	; ,
.equ	Seconds	= 0x71	; .
;  .   
.equ	WT_Start_Minutes = 0x72	; ,
.equ	WT_Start_Seconds = 0x73	;    .
;  .   
.equ	DT_Start_Minutes = 0x74	; ,
.equ	DT_Start_Seconds = 0x75	;    .
;     .
.equ	RButtons_Process = 0x76  
                                

;    0,   
;      .
.def	B_On_Counter  = R1
;    0,   
;      .
.def	B_Off_Counter = R2
; .         EEPROM- .
.def	EE_ADR	= R3
.def	EE_DAT	= R4
;    SREG.
.def	backupSREG = R5
;  .
.def	Reg_Task = R15
;  .
.def	Status   = R16
; .   
;   0-  5-    0-5 .
.def	Indicator_Enabled = R17
; .     .
.def    Indicator_Number  = R18
; .    .
.def    Curent_Symbol     = R19

.def    A  = R20  ;  .
.def    B  = R21  ;  .
.def    C  = R22  ;  C.
.def    AI = R23  ;     .
.def    BI = R24  ;     .
;      LPM.
.def    ResultZ = R0
;================================================================
;  .
;================================================================
.cseg
;  .
.org 0x000
	rjmp	Main
;     OCR1A   TAIMER1.
.org 0x004	
	rjmp	T1A_INT_COMP
;      TAIMER0.
.org 0x006	
	rjmp	T0_INT_OV
;  .
.org 0x012
;================================================================
;  .
;================================================================
;    
; PD0-6,    .
Tab_Dig_Code:
;	"0"	"1"	"2"	"3"	"4"	"5"	"6"	"7"	"8"	"9"
.db	0x77,	0x24,	0x6B,	0x6E,	0x3C,	0x5E,	0x5F,	0x64,	0x7F,	0x7E

;   PB0-2 .     ,
;      .
Tab_Power_Code:
;  	0	1	2	3	4	5
.db     	0x05,	0x04,	0x03,	0x02,	0x01,	0x00
;================================================================
;  .
;================================================================
Main:   
	;  .
	ldi	A,RAMEND
	out	SPL,A
	;  .
	clr	B_On_Counter
	clr	B_Off_Counter
	clr	XH
	clr	YH
	clr	ZH	
	;   0-2,6,7    .
        ldi	A, 0xC7
	out	DDRB, A
	;      PB3, PB4.
	;        . 
	ldi	A, 0x18
	out	PORTB, A
	;   0-6  D  .
	ldi	A, 0x7F
	out	DDRD, A
	;   TAIMER1
	;   /
	; -   4,  OCR1A
	; -  clk/64 (.. 10000000/256=39062.5=9896h)
	ldi	A, 0x00
	out	TCCR1A, A
	ldi	A, 0x0C
	out	TCCR1B, A
	;   OCR1A     TCNT1
	;     .  
	;      , 
        ;      (39062.5 ),  
	;  OCR1A  9896h.
	ldi	A, 0x96
	ldi	B, 0x98
	out	OCR1AL, A
	out	OCR1AH, B
	;     . OCR1A .
	ldi	A, 0x40
	out	TIMSK, A
	;   TIMER0
	;  .
	; -  Normal;
	; - OC0B ;
	; -   clk/1024 ( 9765,625 ).
	ldi	A, 0x00
	out	TCCR0A, A
	ldi	A, 0x05
	out	TCCR0B, A	
	;    .
	
	;    .
	clr	A
	sbr	A, R_Button0_Enable
	sbr	A, R_Button1_Enable
	ldi	XL, RButtons_Process
	st	X, A
	;  .
	sei
	;   .
	clr	Reg_Task
	;   " "
	ldi	Status, S_Delay_Time
	;   .
	ser	Indicator_Enabled
	;   0.
	clr	Indicator_Number
	;     .    .
	ldi	XH, 0
	
	ldi	A,0xFF
	ldi	B,0xFF
Loop:	dec	A
	brne	Loop
	dec	B
	brne	Loop

	;     
	;     (  ).
	;    .
	ldi	A, EE_ADR_WT_M
	mov	EE_ADR, A
	;      EEPROM-.
	rcall	EEPROM_read
	;   EE_DAT   .
	;    SRAM .
	sts	WT_Start_Minutes, EE_DAT
	
	ldi	A, EE_ADR_WT_S
	mov	EE_ADR, A
	rcall	EEPROM_read
	sts	WT_Start_Seconds, EE_DAT
	
	ldi	A, EE_ADR_DT_M
	mov	EE_ADR, A
	rcall	EEPROM_read
	sts	DT_Start_Minutes, EE_DAT
	
	ldi	A, EE_ADR_DT_S
	mov	EE_ADR, A
	rcall	EEPROM_read
	sts	DT_Start_Seconds, EE_DAT
	;      
	;     .
	lds	A, DT_Start_Minutes
	sts	Minutes, A
	lds	A, DT_Start_Seconds
	sts	Seconds, A
;------------------------------------------------------
;   .
;------------------------------------------------------
M_LOOP:	
;------------------------------------------------------
;      6- ,  
; .   pin    Tab_Ports.
;     Indicator_Number.
;------------------------------------------------------
	;       
	;  .
	mov	A, Indicator_Enabled
	mov	B, Indicator_Number
	inc	B
P0:	ror	A
	dec	B
	brne	P0
	brcs	P1
	ldi	B, 0x07
	rjmp	P2  ;     .
P1:	;    Z   
	;   .
	ldi	ZL, LOW(Tab_Power_Code*2) 	 
	ldi	ZH, HIGH(Tab_Power_Code*2)
	;     .
	add	ZL, Indicator_Number
	;    .
	lpm
	;     
	mov	B, ResultZ
	;      pin'a  
	;  .
	;     
	;  D.
	clr	A
	out	PORTD, A
	;   PB6,    .
	cbi	PORTB, 6
P2:	;    . 
	in	A, PORTB
	cbr	A, 0x07
	or	A, B	
	out	PORTB, A
PEnd:	nop
;------------------------------------------------------
;     .
;------------------------------------------------------
	;  Indicator_Number  
	;  0  5,   0,1,2    
	;     (  
	; ),    .
	;    (  )
	;    .   . 
	;   
	sbrs	Indicator_Number, 2
	rjmp	_Continue_Verification
	;  .
	cpi	Status, S_Delay_Time	; 
	brne	_CS1
	ldi	A, Sym_Pro
	ldi	B, Sym_Def
_CS1:	cpi	Status, S_Work_Time	; 
	brne	_CS2
	ldi	A, Sym_Rab
	ldi	B, Sym_Def
_CS2:	ldi	C, S_Set_WT_Minutes	; 
	ori	C, S_Set_WT_Seconds	; 
	and	C, Status		; .
	breq	_CS3
	ldi	A, Sym_Ust
	ldi	B, Sym_Rab
_CS3:	ldi	C, S_Set_DT_Minutes	; 
	ori	C, S_Set_DT_Seconds	; 
	and	C, Status		; .
	breq	_CS4
	ldi	A, Sym_Ust
	ldi	B, Sym_Pro
_CS4:	cpi	Status, S_FULL		; 
	brne	_CS5
	ldi	A, Sym__
	ldi	B, Sym_F
_CS5:	sbrs	Indicator_Number, 0
	mov	A, B
	rjmp	_Symbol_View

_Continue_Verification:
	;     , 
	;     
	;   .
	cpi	Status, S_FULL
	brne	CV1
	cpi	Indicator_Number, 0
	brne	CV01
	ldi	A, Sym__
CV01:	cpi	Indicator_Number, 1
	brne	CV02
	ldi	A, Sym_L
CV02:	cpi	Indicator_Number, 2
	brne	CV03
	ldi	A, Sym_L
CV03:	cpi	Indicator_Number, 3
	brne	_Symbol_View
	ldi	A, Sym_U
	rjmp	_Symbol_View	
CV1:	
	;      0-  
	lds	B, Seconds
	;  1,  Minutes
	;    
	sbrc	Indicator_Number, 1
	lds	B, Minutes
	;  1-    
	;   0,  Seconds

	;  .      100
	;       
	;       .
	clr	A
V0:	cpi	B, 10
	brlo	V1
	subi	B, 10
	inc	A
	rjmp	V0
V1:	nop
	;     .   
	; ,     .
	
	;      (0,2,4)   
	;  Curent_Symbol   . 
	; ,  (1,3,5)  ..
	;     0.
	;     .
	mov	Curent_Symbol, B
	sbrc	Indicator_Number, 0
	mov	Curent_Symbol, A

;------------------------------------------------------
;   .     
; Tab_Dig_Code,       
;   (8 ),     
;   .  
;------------------------------------------------------
	;       .
	mov	A, Curent_Symbol
	;   Z    .
	ldi	ZL, LOW(Tab_Dig_Code*2) 	 
	ldi	ZH, HIGH(Tab_Dig_Code*2)
	;  .
	add	ZL, A
	lpm	; 
	mov	A, ResultZ
	;      .
	cpi	Indicator_Number, 2
	brne	_Symbol_View
	;   .
	sbi	PORTB, 6
_Symbol_View:
	;     .
	out	PORTD, A
	;         
	;    .
	ldi	A,0x55
S0:	dec	A
	brne	S0
	;     - .
	inc	Indicator_Number
	cpi     Indicator_Number, 0x06
	brlo	S1	
	clr     Indicator_Number
S1:	nop
	;       0.
	lds	A, RButtons_Process
	andi	A, R_Button0_Enable
	breq	M_RBE1
	;   .
	sbic	PINB, 0x03
	rjmp    M_RBE1
	;  .
	rcall	Button0_Processing
M_RBE1:	
	;       1.
	lds	A, RButtons_Process
	andi	A, R_Button1_Enable
	breq	M_RBE2
	;   .
	sbic	PINB, 0x04
	rjmp    M_RBE2
	;  .
	rcall	Button1_Processing
M_RBE2:
	ldi	AI, S_Delay_Time
	ori	AI, S_Work_Time
	and	AI, Status
	breq	M_RBE3
	;   
	sbis	PINB, 0x05
	;  .
	rcall	B_FULL_Processing
M_RBE3:
	cpi	Status, S_FULL
	brne	M_END
	;   
	sbic	PINB, 0x05
	rcall	B_Not_FULL_Processing
M_END:	;   .
	rjmp	M_LOOP
;   .
;==========================================================
;  ().
;==========================================================
;    0.
Button0_Processing:
	; .
	cbi	PORTB, 7
	;  .
	ldi	A, S_Delay_Time
	ori	A, S_Work_Time
	ori	A, S_FULL
	and	A, Status
	breq	IN_S2
	;    . .
	;    .
	ldi	Indicator_Enabled, 0x3C
	;  ().
	ldi	Status, S_Set_WT_Minutes
	;      
	; .
	lds	A, WT_Start_Minutes
	sts	Minutes, A
	rjmp	IN_E
IN_S2:	
	cpi	Status, S_Set_WT_Minutes
	brne	IN_S3
	ldi	Indicator_Enabled, 0x33
	ldi	Status, S_Set_WT_Seconds
	lds	A, WT_Start_Seconds
	sts	Seconds, A
	rjmp	IN_E
IN_S3:	
	cpi	Status, S_Set_WT_Seconds
	brne	IN_S4
	ldi	Indicator_Enabled, 0x3C
	ldi	Status, S_Set_DT_Minutes
	lds	A, DT_Start_Minutes
	sts	Minutes, A
	rjmp	IN_E
IN_S4:	
	cpi	Status, S_Set_DT_Minutes
	brne	IN_S5
	ldi	Indicator_Enabled, 0x33
	ldi	Status, S_Set_DT_Seconds
	lds	A, DT_Start_Seconds
	sts	Seconds, A
	rjmp	IN_E
IN_S5:	
	cpi	Status, S_Set_DT_Seconds
	brne	IN_E
	ldi	Indicator_Enabled, 0x3F
	ldi	Status, S_Delay_Time
	;      
	;      EEPROM-.
	lds	EE_DAT, WT_Start_Minutes
	ldi	A, EE_ADR_WT_M
	mov	EE_ADR, A
	;     EEPROM.
	rcall	EEPROM_write
	lds	EE_DAT, WT_Start_Seconds
	ldi	A, EE_ADR_WT_S
	mov	EE_ADR, A
	rcall	EEPROM_write
	lds	EE_DAT, DT_Start_Minutes
	sts	Minutes, EE_DAT
	ldi	A, EE_ADR_DT_M
	mov	EE_ADR, A
	rcall	EEPROM_write
	lds	EE_DAT, DT_Start_Seconds
	sts	Seconds, EE_DAT
	ldi	A, EE_ADR_DT_S
	mov	EE_ADR, A
	rcall	EEPROM_write
	;rjmp	IN_E	
IN_E:	
	;      .
	mov	A, Reg_Task
	sbr	A, T_Check_Button_Off
	mov	Reg_Task, A
	;    0.
	lds	A, RButtons_Process
	cbr	A, R_Button0_Enable
	sts	RButtons_Process, A
	;      0.
	in	A, TIMSK
	ori	A, 0x02
	out	TIMSK, A
	ret
;    0
;==========================================================
;==========================================================
;    1.
Button1_Processing:
	; .
	cbi	PORTB, 7
	;  .
	ldi	A, S_Set_WT_Minutes
	ori	A, S_Set_WT_Seconds
	ori	A, S_Set_DT_Minutes
	ori	A, S_Set_DT_Seconds
	and	A, Status
	breq	B1P_E
	;    
	;  WT_Start_Minutes,WT_Start_Seconds,
	; DT_Start_Minutes, DT_Start_Seconds   
        ;  .
	rcall	Func_Inc_Time
	;      .
	mov	A, Reg_Task
	sbr	A, T_Check_Button_Off
	;      .
	sbr	A, T_Check_Button_On
	mov	Reg_Task, A
	;    1.
	lds	A, RButtons_Process
	cbr	A, R_Button1_Enable
	sts	RButtons_Process, A
	;      0.
	in	A, TIMSK
	ori	A, 0x02
	out	TIMSK, A
B1P_E:	
	ret
;    1.
;==========================================================
;==========================================================
;     
;   WT_Start_Minutes,WT_Start_Seconds,
; DT_Start_Minutes, DT_Start_Seconds   
;  .
Func_Inc_Time:
	ldi	YH, 0
	;  .
	cpi	Status, S_Set_WT_Minutes
	brne	FIT1	
	;   .
	lds	AI, WT_Start_Minutes 
	inc	AI
	sts	WT_Start_Minutes, AI
	;  .
	cpi	AI, 60
	brlo	FITEnd
	;   .
	clr	AI
	sts	WT_Start_Minutes, AI
	rjmp	FITEnd
FIT1:	
	cpi	Status, S_Set_WT_Seconds
	brne	FIT2
	;   .	
	lds	AI, WT_Start_Seconds 
	inc	AI
	sts	WT_Start_Seconds, AI
	;  .
	cpi	AI, 60
	brlo	FITEnd
	;   .
	clr	AI
	sts	WT_Start_Seconds, AI
	rjmp	FITEnd
FIT2:	
	cpi	Status, S_Set_DT_Minutes
	brne	FIT3	
	;   .
	lds	AI, DT_Start_Minutes 
	inc	AI
	sts	DT_Start_Minutes, AI
	;  .
	cpi	AI, 60
	brlo	FITEnd
	;   .
	clr	AI
	sts	DT_Start_Minutes, AI
	rjmp	FITEnd
FIT3:	
	cpi	Status, S_Set_DT_Seconds
	brne	FITEnd
	;   .	
	lds	AI, DT_Start_Seconds 
	inc	AI
	sts	DT_Start_Seconds, AI
	;  .
	cpi	AI, 60
	brlo	FITEnd
	;   .
	clr	AI
	sts	DT_Start_Seconds, AI
	;rjmp	FITEnd
FITEnd:
	sts	Minutes, AI
	sts	Seconds, AI
	ret
;  .
;==========================================================
;==========================================================
;       EEPROM-.
;   EE_ADR  .
;   EE_DAT  .	
EEPROM_read:
	; Wait for completion of previous write
	sbic EECR,EEPE
	rjmp EEPROM_read
	; Set up address (EE_ADR) in address register
	out EEAR, EE_ADR
	; Start eeprom read by writing EERE
	sbi EECR,EERE
	; Read data from data register
	in EE_DAT,EEDR
	ret
;==========================================================	
;==========================================================
;       EEPROM-.
;   EE_ADR  .
;   EE_DAT  .	
EEPROM_write:
	; Wait for completion of previous write
	sbic EECR,EEPE
	rjmp EEPROM_write
	; Set up address (EE_ADR) in address register
	out EEAR, EE_ADR
	; Write data (EE_DAT) to data register
	out EEDR, EE_DAT
	; Write logical one to EEMPE
	sbi EECR,EEMPE
	; Start eeprom write by setting EEPE
	sbi EECR,EEPE
	ret
;==========================================================
;==========================================================
;     
; " ".
B_FULL_Processing:
	; .
	cbi	PORTB, 7
	ldi	Status, S_FULL
	ret
;   B_FULL_Processing.
;==========================================================
;==========================================================
;     .
B_Not_FULL_Processing:
	ldi	Status, S_Delay_Time
	lds	A, DT_Start_Minutes
	sts	Minutes, A
	lds	A, DT_Start_Seconds
	sts	Seconds, A
	ret	
;   B_Not_FULL_Processing.
;==========================================================
;  .
;==========================================================
;      0
T0_INT_OV:
	;  SREG
	in	backupSREG, SREG
	;  .
	mov	AI, Reg_Task
	andi	AI, T_Check_Button_On
	breq	OVT2
	;      #1.
	;    ?
	;   B.
	sbic	PINB, 4
	rjmp	OVCL
	;  .    1.
	inc	B_On_Counter	
	;      .
	;   60
	mov	AI, B_On_Counter
	cpi	AI, 0x3C
	brne	OVT2
	;  .
	;    45.
	ldi	AI, 0x30
	mov	B_On_Counter, AI
	;    
	;  WT_Start_Minutes,WT_Start_Seconds,
	; DT_Start_Minutes, DT_Start_Seconds.
	rcall	Func_Inc_Time
	rjmp	OVT2
OVCL:	;  .
	clr	B_On_Counter
	;  .
	mov	AI, Reg_Task
	cbr	AI, T_Check_Button_On
	mov	Reg_Task, AI
OVT2:	
	mov	AI, Reg_Task
	andi	AI, T_Check_Button_Off
	breq	OVE
	;     .
	;    ?
	;   B.
	in	AI, PINB
	andi	AI, 0x18
	cpi	AI, 0x18
	brne	OVX
	;      .
	;    1.
	inc	B_Off_Counter
	;      .
	;    65,   
	; B_Off_Counter'  5  5*256*0.000256=0.325  	
	mov	AI, B_Off_Counter
	cpi	AI, 0x09
	brne	OVE
	;  .
	;     0  1.
	clr	AI
	sbr	AI, R_Button0_Enable
	sbr	AI, R_Button1_Enable
	sts	RButtons_Process, AI
	;  .
	mov	AI, Reg_Task
	cbr	AI, T_Check_Button_Off
	mov	Reg_Task, AI
	;    0.
	in	AI, TIMSK
	cbr	AI, 0x02
	out	TIMSK, AI
OVX:	;  .
	clr	B_Off_Counter
OVE:	
	;  SREG.
	out	SREG,backupSREG
	reti
;       0
;==========================================================

;==========================================================	
;     OCR1A  TAIMER1.
T1A_INT_COMP:
	;  SREG
	in	backupSREG, SREG
	;   OCR1A     TCNT1
	;     .  
	;     (9896h).   
	;        
	; .
	ldi	AI, 0x96
	ldi	BI, 0x98
	out	OCR1AL, AI
	out	OCR1AH, BI
	ldi	AI, S_Delay_Time
	ori	AI, S_Work_Time
	and	AI, Status
	breq	TEOR
	ldi	YL, Seconds
	ld	AI, Y
	;  .
	cpi	AI, 0
	brne	T1A_1
	;    .  .
	ldi	AI, 59
	st	Y, AI
	
	ldi	YL, Minutes
	ld	AI, Y
	;  .
	cpi	AI, 0
	brne	T1A_1
	;    .
	;     .
	ldi	BI, S_Delay_Time
	eor	Status, BI
	ldi	BI, S_Work_Time
	eor	Status, BI
	
	cpi	Status, S_Delay_Time
	brne	T1A_PR
	;  .  .
	cbi	PORTB, 7
	ldi	AI, DT_Start_Minutes
	ldi	BI, DT_Start_Seconds
	rjmp	T1A_0
T1A_PR:
	;  .  .
	sbi	PORTB, 7
	ldi	AI, WT_Start_Minutes
	ldi	BI, WT_Start_Seconds
T1A_0:	
	mov	YL, AI
	ld	AI, Y
	sts	Minutes, AI
	mov	YL, BI
	ld	BI, Y
	sts	Seconds, BI
	rjmp	TEOR
T1A_1:	;   .
	dec	AI
	st	Y, AI
TEOR:	
	;  SREG.
	out	SREG,backupSREG
	reti
;      OCR1A  TAIMER1.
;==========================================================
