;***************************************************************************
;*					   120  v1.0
;***************************************************************************
.nolist
.include "8515def.inc"
.list
.equ	fsck = 3618400
;****************************
.LISTMAC 
.MACRO ldi2          
        ldi @0,@1  
        ldi @2,@3  
.ENDMACRO 
.MACRO	ldio
		ldi	temp,@1
		out	@0,temp
.ENDMACRO
;****************************
.equ	ticksec = ((fsck/256)/256)/8
;***** Global
.def	temp	= r16;
.def	dlit	= r22;
.def	mdlit	= r18
.def  	maxcntH  = r7
.def	maxcntL	 = r8
.def	EEd		=r23		;data byte to EEPROM
.def	EEal	=r24		;address low byte to write to
.def	EEah	=r25		;address high byte to write to
.def	temp1	=r17

;***** Code

	rjmp	RESET			;Reset Handle
	rjmp	Lab_INT0addr	;External Interrupt0 Vector Address
	rjmp	Lab_INT1addr	;External Interrupt1 Vector Address
	rjmp	Lab_ICP1addr	;Input Capture1 Interrupt Vector Address
	rjmp	Lab_OC1Aaddr	;Output Compare1A Interrupt Vector Address
	rjmp	Lab_OC1Baddr	;Output Compare1B Interrupt Vector Address
	rjmp	Lab_OVF1addr	;Overflow1 Interrupt Vector Address
	rjmp	Lab_OVF0addr	;Overflow0 Interrupt Vector Address
	rjmp	Lab_SPIaddr 	;SPI Interrupt Vector Address
	rjmp	Lab_URXCaddr	;UART Receive Complete Interrupt Vector Address
	rjmp	Lab_UDREaddr	;UART Data Register Empty Interrupt Vector Address
	rjmp	Lab_UTXCaddr	;UART Transmit Complete Interrupt Vector Address
	rjmp	Lab_ACIaddr 	;Analog Comparator Interrupt Vector Address

Lab_INT0addr: 	reti
Lab_INT1addr: 	reti
Lab_ICP1addr: 	reti
Lab_OC1Aaddr: 	reti
Lab_OC1Baddr: 	reti
Lab_SPIaddr: 	reti
Lab_URXCaddr: 	reti
Lab_UDREaddr: 	reti
Lab_UTXCaddr: 	reti
Lab_ACIaddr: 	reti
Lab_OVF1addr: 	reti

Lab_OVF0addr: 	;    0
		dec dlit
 		reti
WaitDlit: ;   
again:
		sei
		nop
		nop
		cli
		clc
		cpi		dlit,0
		brne	again
		ret
;************************************************
sound:  ;  
		push	temp
		out		OCR1AH,maxcntH
		out		OCR1AL,maxcntL
		ldio	tccr1b,$9
		pop		temp
		ret
;*************************************************
nosound: ;  
		push	temp
		ldio	tccr1b,0
		pop		temp
		ret
;*************************************************
pause:  ;     ,   
		ldi		dlit,ticksec/2
		rcall	WaitDlit
		ret
;*************************************************
setdlit: ;      
		push	temp
		push	r2
		push	r3
		ldi		temp,0
		mov		dlit,temp
		mov		r3,temp
		ldi		temp,ticksec 
mm:		add		dlit,temp
		dec		r2
		cp		r2,r3
		brne	mm
		pop		r3
		pop		r2
		pop		temp
		ret
;*****************************************
playnote:  ;r1 = numnote r2=numdlit if r1=$fe then pause
        cli
		push	zl
		push	zh
		push	temp
		push	r1
		push	r2

		clc
		ldi		temp,$fe
		cp		r1,temp
		brne 	normalnote
		rcall	setdlit
		rcall	nosound
		rcall	WaitDlit
		rjmp	end_playnote
normalnote:
		ldi2 zl,low(notes*2),zh,high(notes*2)
		lsl r1
		clc
		add	zl,r1
		clr	temp
		adc	zh,temp
       	lpm
		mov	maxcntL,r0
		ldi	temp,1
		clc
		add	zl,temp
		clr	temp
		adc	zh,temp
       	lpm
		mov	maxcntH,r0
		rcall	setdlit		
		rcall	sound
		rcall	WaitDlit
		rcall	nosound
end_playnote:
		rcall	pause

		pop		r2	
		pop		r1
		pop		temp
		pop		zh
		pop		zl
		ret
EEWrite:  ;    EEPROM
	sbic	EECR,EEWE	;if EEWE not clear
	rjmp	EEWrite		;    wait more
	out 	EEARH,EEah	;output address high for 8515
	out		EEARL,EEal	;output address low for 8515
	out		EEDR,EEd	;output data
	sbi 	EECR,EEMWE	;set master write enable, remove if 1200 is used	
	sbi		EECR,EEWE	;set EEPROM Write strobe
						;This instruction takes 4 clock cycles since
						;it halts the CPU for two clock cycles
	ret

EERead:	 ;   EEPROM
	sbic	EECR,EEWE	;if EEWE not clear
	rjmp	EERead		;    wait more
	out 	EEARH,EEah	;output address high for 8515
	out		EEARL,EEal	;output address low for 8515
	sbi		EECR,EERE	;set EEPROM Read strobe
						;This instruction takes 4 clock cycles since
						;it halts the CPU for two clock cycles
	in		EEd,EEDR	;get data
	ret

loadZ:  ;  Z   EEPROM
		push	EEd
		ldi2	EEah,high(mzh),EEal,low(mzh)
		rcall	EERead
		mov		zh,EEd
		ldi2	EEah,high(mzl),EEal,low(mzl)
		rcall	EERead
		mov		zl,EEd
		pop		EEd
		ret
		
saveZ:	;   Z  EEPROM
		push	EEd
		push	temp
		ser		temp
		ldi2    EEah,high(mzh), EEal,low(mzh)
		mov		EEd,zh
		rcall	EEWrite
		ldi2	EEah,high(conth),EEal,low(conth)
		mov		EEd,zh
		eor		EEd,temp
		rcall	EEWrite
		ldi2	EEah,high(mzl),EEal,low(mzl)
		mov		EEd,zl
		rcall	EEWrite
		ldi2	EEah,high(contl),EEal,low(contl)
		mov		EEd,zl
		eor		EEd,temp
		rcall	EEWrite
		pop		temp
		pop		EEd
		ret
ZLSave: ;  Z     EEPROM
		ldi2	zl,low(mymelody*2),zh,high(mymelody*2)
		rcall	saveZ
		ret
chkee:  ;     EEPROM
		push	EEd
		push	temp
		push	temp1
		ser		temp1
		ldi2	EEah,high(mzh),EEal,low(mzh)
		rcall	EERead
		mov		temp,EEd
		ldi2	EEah,high(conth),EEal,low(conth)
		rcall	EERead
		eor		EEd,temp1
		cp		temp,EEd
		breq	okH
		rcall	ZLsave
		rjmp	mexit
okH:		
		ldi2	EEah,high(mzl),EEal,low(mzl)
		rcall	EERead
		mov		temp,EEd
		ldi2	EEah,high(contl),EEal,low(contl)
		rcall	EERead
		eor		EEd,temp1
		cp		temp,EEd
		breq	mexit
		rcall	ZLsave
mexit:
		pop		temp1
		pop		temp
		pop		EEd
		
		ret

RESET:

	;  	
	ldio	SPL,low(RAMEND)		; Load low byte address of end of RAM into register R16
								; Initialize stack pointer to end of internal RAM
	ldio	SPH,high(RAMEND)	; Load high byte address of end of RAM into register R16	
							    ; Initialize high byte of stack pointer to end of internal RAM
	ldio	timsk,$2;     0
	ldio	tccr0,$4;      fsck/256
	ser		temp
	out		ddra,temp  ;  port  
	out		porta,temp ;    port  1    

	ldio	TCCR1A,$40 ;    1     OC1A(PD5)
	ldio	ddrd,$ff	;  portd  
	ldio	mcucr,32	;    
	cli
	rcall	chkee  ;   EEPROM
	rcall	loadZ  ;    
nexta:
	lpm  	;r0 = nota
	ser	  	temp
	cp	  	r0,temp
	breq  	forever

	ldi		temp,$fd
	cp		r0,temp   ;     ?
	breq	end_all

	mov	  	r1,r0   ; r1= nota
    adiw	ZH:ZL,1
	lpm    	; r0 = dlit
	mov		r2,r0
	rcall 	playnote
	adiw ZH:ZL,1
	rjmp nexta
	
forever: 
	adiw ZH:ZL,2
    rcall	saveZ
;power off
	clr		temp
	out		porta,temp  ;  
    ;	rjmp main
	cli
mstop: 
    sbi	portb,0
	sleep
rjmp mstop

end_all: ; C    
	ldi2	zl,low(mymelody*2),zh,high(mymelody*2)
	rjmp	nexta
;
mymelody:
;begin melodies
.include "mel.inc"

;end of melodies
.db  $fd,$fd

notes: ;  
 .dw ((fsck)/(262*2))       	; 	C-
 .dw ((fsck)/(277*2))			;	C#-
 .dw ((fsck)/(294*2))			;	D-
 .dw ((fsck)/(311*2))			;	D#-
 .dw ((fsck)/(330*2))			;	E-
 .dw ((fsck)/(349*2))			;	F-
 .dw ((fsck)/(370*2))			;	F#-
 .dw ((fsck)/(392*2))			;	G-
 .dw ((fsck)/(415*2))			;	G#-
 .dw ((fsck)/(440*2))			;	A
 .dw ((fsck)/(466*2))			;	A#
 .dw ((fsck)/(494*2))			;	B
 .dw ((fsck)/(262*2*2))		;	C
 .dw ((fsck)/(277*2*2))		;	C#
 .dw ((fsck)/(294*2*2))		;	D
 .dw ((fsck)/(311*2*2))		;	D#
 .dw ((fsck)/(330*2*2))		;	E
 .dw ((fsck)/(349*2*2))		;	F
 .dw ((fsck)/(370*2*2))		;	F#
 .dw ((fsck)/(392*2*2))		;	G
 .dw ((fsck)/(415*2*2))		;	G#
 .dw ((fsck)/(440*2*2))		;	A+
 .dw ((fsck)/(466*2*2))		;	A#+
 .dw ((fsck)/(494*2*2))		;	B+
 .dw ((fsck)/(262*4*2))		;   ..
 .dw ((fsck)/(277*4*2))
 .dw ((fsck)/(294*4*2))
 .dw ((fsck)/(311*4*2))
 .dw ((fsck)/(330*4*2))
 .dw ((fsck)/(349*4*2))
 .dw ((fsck)/(370*4*2))
 .dw ((fsck)/(392*4*2))
 .dw ((fsck)/(415*4*2))
 .dw ((fsck)/(440*4*2))
 .dw ((fsck)/(466*4*2))
 .dw ((fsck)/(494*4*2))

 
.db 13,10,13,10,"Misha Beletski 2003 (C) "

.eseg
	mzl: 	.db low(mymelody*2)
	mzh: 	.db high(mymelody*2)
	contl : .db low(mymelody*2)^$ff
	conth : .db high(mymelody*2)^$ff


