//
//    PIC-
//   ..
//  1.2 (    )
//


////////////////////////////////////////////////
//               Common variables
////////////////////////////////////////////////

char day; //0 - unknown, 1 - mo, ...   
char hour,min,sec;
char aday,ahour,amin,asec;    //aday = [CCSxDDDD], DDDD=8   //CC=0..3
char old7,new7,old6,new6;
char ibuf,obuf;
char cbit,cbyte;
char s1,s2,s3,s4;
char keycode,keytimer;

////////////////////////////////////////////////
//               EEPROM procedures
////////////////////////////////////////////////

void write_flash( char addr, char data )
{
    //Write flash
    EEADR = addr;
    EEDATA = data;

    set_bit( STATUS, RP0 );
    set_bit( EECON1, WREN );
    EECON2 = 0x55;
    EECON2 = 0xAA;
    set_bit( EECON1, WR );
    while(EECON1&2);
    clear_bit( EECON1, WREN );

    clear_bit( STATUS, RP0 );
}

char read_flash( char addr )
{
    //Read flash
    EEADR = addr;
    set_bit( STATUS, RP0 );
    set_bit( EECON1, RD );
    clear_bit( STATUS, RP0 );
    asm movf EEDATA, W
}

////////////////////////////////////////////////
//               INIT procedures
////////////////////////////////////////////////

void init()                  //
     {
     set_bit(STATUS,RP0);
     TRISA=0x10;                // A     IOOOO
     TRISB=0xCF;                // B  IIOOIIII
     OPTION_REG=0x26;           
     clear_bit(STATUS,RP0);
     INTCON=0xA0;               //GIE|RTIF
     PORTA=0x0;
     PORTB=0x0;
     }

void state(char num,char ustate)//   num
     {
     switch (num)
          {
          case 0:s1=ustate;if (ustate) set_bit(PORTA,0); else clear_bit(PORTA,0);return;
          case 1:s2=ustate;if (ustate) set_bit(PORTA,1); else clear_bit(PORTA,1);return;
          case 2:s3=ustate;if (ustate) set_bit(PORTA,2); else clear_bit(PORTA,2);return;
          case 3:s4=ustate;if (ustate) set_bit(PORTA,3); else clear_bit(PORTA,3);return;
          }
     }

////////////////////////////////////////////////
//               CLOCK procedures
////////////////////////////////////////////////

void updatetimer()              // + 1 
     {
     if (day>0) 
        {
        if (++sec==60)
           {
           sec=0;
           if (++min==60)
              {
              min=0;
              if (++hour==24)
                 {
                 hour=0;
                 if (++day==8) day=1;
                 }
              }
           }
        }   
     }

char checkalarm()               //compare current time to atime
     {
     if ((aday&0xf)<8)          //   
        if (day!=(aday&0xf)) return 0;
     if (hour!=ahour) return 0;
     if (min!=amin) return 0;
     if (sec!=asec) return 0;
     return 1;
     }

char alarmnum;

void getalarm()                 //  alarmnum  atime
     {
     char adr=alarmnum<<2;
     aday=read_flash(adr++);
     ahour=read_flash(adr++);
     amin=read_flash(adr++);
     asec=read_flash(adr);
     }

//  alarmnum  atime
//void setalarm()
//     {
//     char adr=alarmnum<<2;
//     write_flash(adr++,aday);
//     write_flash(adr++,ahour);
//     write_flash(adr++,amin);
//     write_flash(adr,asec);
//     }

void check()                    // 
     {
     for (alarmnum=0;alarmnum<16;alarmnum++)
         {
//         clear_wdt();
         getalarm();
         if (day>0)
            if (checkalarm())
               state(aday>>6,(aday>>5)&1);
         }
     }

////////////////////////////////////////////////
//                Interrupt
////////////////////////////////////////////////
void interrupt()                // 
     {
     updatetimer();
     clear_bit(INTCON,T0IF);
     }

////////////////////////////////////////////////
//                   PC link
////////////////////////////////////////////////
void download(char num,char data) // 
     {
     switch (num)
            {
            case 74:if (data!=0xf5) {cbit=0;cbyte=0;};break;
            case 75:state(0,data);break;
            case 76:state(1,data);break;
            case 77:state(2,data);break;
            case 78:state(3,data);break;
            case 79:sec=data;break;
            case 80:min=data;break;            
            case 81:hour=data;break;            
            case 82:day=data;break;            
            default: if (num>82) write_flash(num-83,data);
            }
     }

char upload(char num)             // 
     {
     switch (num)
            {
            case 0:return 0xf5;break;
            case 1:return input_pin_port_a(0);break;
            case 2:return input_pin_port_a(1);break;
            case 3:return input_pin_port_a(2);break;
            case 4:return input_pin_port_a(3);break;
            case 5:return sec;break;
            case 6:return min;break; 
            case 7:return hour;break;            
            case 8:return day;break;
            case 73:return 0x50;break;
            default: if (num<73) return read_flash(num-9); else return 0x55;
            }
     }

void scankey()                    // 
     {
     keycode=(~PORTB)&0xf;
     if (keycode==0) keytimer=0;
     if (keytimer<200) keytimer++;
     if (keytimer==200)           //   200 
        {
        keytimer++;        
        if (keycode&1) state(0,!s1);
        if (keycode&2) state(1,!s2);        
        if (keycode&4) state(2,!s3);        
        if (keycode&8) state(3,!s4);        
        }
     }

////////////////////////////////////////////////
//                   MAIN
////////////////////////////////////////////////
//B0..B3 - buttons
//B4 - reserved
//B5 - CTS
//B6 - RTS
//B7 - DTR
////////////////////////////////////////////////

void main()
     {
     if (STATUS&0x10)
        {
        day=0;hour=0;min=0;sec=0;
        s1=0;s2=0;s3=0;s4=0;
        keycode=0;keytimer=0;
        init();
        }

     old7=input_pin_port_b(7); //DTR sync
     old6=input_pin_port_b(6); //RTS data

     cbyte=0;cbit=0;

     for (;;)                     // 
         {
         check();
         scankey();
         
         new7=input_pin_port_b(7); 
         new6=input_pin_port_b(6); 

         if ((new6!=old6)&&(new7)) //  
            {
            cbit=0;
            cbyte=0;
            ibuf=0;
            }
         else if ((new7)&&(!old7)) //  
            {
            ibuf<<=1;
            if (input_pin_port_b(6)) ibuf++;
            if (cbit==0) 
               {
               download(cbyte-1,ibuf);
               ibuf=0;
               }
            }
         
         if ((!new7)&&(old7))      //  
            {
            if (cbit==0)
               obuf=upload(cbyte);

            if (obuf&0x80) output_high_port_b(5); else output_low_port_b(5);
            obuf<<=1;
            cbit++;
            if (cbit==8)
               {
               cbit=0;
               cbyte++;
               }
            }

         old7=new7;
         old6=new6; 
         }
     }
     
     