/*************************************************************/
/*                                                           */
/*        ணࠬ 㭨ᠫ쭮 ⠩/ମ        */
/*               ப஫ PIC16F876               */
/*                                                           */
/*           (c) 2003  ਩ ᠭ஢           */
/*                     ࠢ 饭                     */
/*                                                           */
/*        । ணࠬ஢: HI-TECH PIC C v8.00        */
/*                                                           */
/*           ᫥ : 16  2003 .          */
/*                                                           */
/*************************************************************/

#include <pic.h>

#include <math.h>
#include <string.h>

#define  AL_ADDR   0x12
#define  OPT_ADDR  0x16
#define  TREG_ADDR 0x18
#define  B_ADDR    0x1A
#define  R0_ADDR   0x1C
#define  RD_ADDR   0x1E
#define  RSRC_ADDR 0x20
#define  TD_ADDR   0x22
#define  AD_ADDR   0x24
#define  BEEP_ADDR 0x26
#define  TB_ADDR   0x27
#define  TC_ADDR   0x28
#define  AC_ADDR   0x29
#define  KPD_ADDR  0x2A
#define  CORR_ADDR 0x2B
#define  BI_ADDR   0x2D

#define  RELE1     RA2
#define  RELE2     RB3
#define  RELE3     RB6
#define  RELE4     RB7
#define  SND       RA3
#define  LEDR      RC0
#define  LEDG      RC1
#define  INF       RC2
#define  CLC       RC3
#define  Keys1     RB0
#define  Keys2     RB1
#define  VDD       RB2

#define  BE        1
#define  LE        2
#define  SE        4
#define  KE        8
#define  RTCE      16
#define  ALE       32
#define  ECE       64
#define  TEMPE     128
#define  TREGE     256
#define  HC        512
#define  HE        1024

#define DelayUS(x) { char _dcnt = (x) / 3; \
                     while(_dcnt-- > 0); }

//  ப ਢ⢨
const char *Hello [] = { "E       L", "HE     LO", " HE   LO ",
                         "  HE LO  ", "  HELLO  " };

enum Modes { TIMER = 0, CLOCK, ALARM, CALIBRATE, EVERY_CLOCK, CORR,
             BEEP = 100, LED, SOUND, R1_SRC, R2_SRC, R3_SRC, R4_SRC,
             HEAT_COOL, HELLO,
             TERM = 200, TREG, SET_BI, SET_B, SET_R0, SET_RD,
             EXIT_MODE = 254, NO_MODE };

enum Modes bank1 MODE = TIMER; // 騩 ० ࠡ
char i, j, K;         // ᯮ⥫ ६
char bank1 s [6];     // --//--
enum Modes bank1 mtmp;
char bank1 nzt  = 0;  // ᫮ ࠡ⠢ ⠩஢  饬 ᪥
char bank1 src  = 0;  // 筨 㪮 ᨣ
char bank1 nvd  = 0;  //  樨 뢮 ᨬ
char bank1 Key  = 0;  // , ᮮ⢥騩 ⮩ 
char bank1 VT   = 0;  //  ⨢ ⠩
char bank1 ds   = 0;  // 稪 ६ 稢 
char bank1 STOP = 1;  // ਧ ⪫祭 ⠭
unsigned int bank1 opt  = KE; // 樨 ਡ
unsigned int bank1 RSRC = 0xAAAA;
unsigned int bank2 _HMS [9];  //  ணࠬ ⠩஢
char bank2 ZT [9];            //  ࠡ⠢ ⠩஢
char bank1 d [9];             // ,    ⮡ࠦ
char bank1 od [9];            // , ⮡ࠦ  ⥪騩 
unsigned int bank1 SF = 0;    // 1  ࠧ拉 ࠧ蠥 ࠡ
                              // ᮮ⢥饣 ⠩
unsigned int bank1 cnt = 0;  // 稪 2- ࢠ
char bank1 kp  = 0;           // 稪 ६ 室  ० ᮢ
int bank1 cr = 0;             // ࢠ  ᨣ  2- ࢠ
unsigned int bank1 nr = 0;   // ⢮ 㪮 祪   ᨣ
char bank1 refresh = 0;       // ਧ ࠧ襭 ⮡ࠦ ଠ樨
                              //  
char bank1 newsec = 0;
char bank1 adce = 0;

unsigned int bank1 Timer_D;
unsigned int bank1 Alarm_D;
char bank1 Beep_D;
char bank1 TB;
char bank1 Timer_C;
char bank1 Alarm_C;
char bank1 KPD;
unsigned int  bank1 CT;

unsigned long int Ticks = 12 * 3600UL; // 
unsigned long int AL; // 㤨쭨

char bank2 TRO = 0; // ਧ 祭 ५ ମॣ

int bank2 Temp, TReg;  // 祭 ⥬  ମॣ

unsigned int bank1 BI; // ਭ ⫨ १ ମॣ

unsigned int bank1 B;  // ⠭ B ମ१
unsigned int bank1 Rd; // ⨢ . १ ()
unsigned int bank1 R0; // ⠭ R0 ମ१ (* 1000)
unsigned int bank1 Ut = 0; // 10-ࠧ來 祭 

double bank1 R0f; // ⢥ ⠭ R0 ମ१

 // ⠭ n-  ६ SF  ﭨ v
 void SFS (char n, char v);

 // ⥭ n-  ६ SF
 char SFR (char n);

 // ८ࠧ ᫠  ப ᨬ
 void itoa10 (long int i);

 //  ᫮ v   a 
 void WriteEEPROM16 (char a, unsigned int v);

 // ⥭ ᫮   a 
 unsigned int ReadEEPROM16 (char a);

 //    ᨬ 頥 7-ᥣ 
 char Syms (char c);

 //   ⮩  頥 ᮮ⢥騩  ᨬ
 char Decode (char c);

 // ⠭ ⥪騩 ࠧ 
 void SetNR (char n);

 // 뢠  ॣ  7-ᥣ  ᨬ n
 void SetDIG (char n);

 //   뢮 ᨬ d ᨬ ப s
 void FillD (const char *s);

 // ⢫ প  cnt 
 void DelayMS (unsigned int cnt);

 // 뢮 ᮮ饭  ப s  
 void OutMessage (const char *s);

 // 뢮   祭 ⥪饣 ⠩
 void OutTimer (void);

 // 뢮   祭 ६ t (str - 砫 ப, ਬ
 // "CLC"); dot - ਧ ⮡ࠦ 饩 窨  ᫥ ࠧ拉
 // ( dot == 1, 窠 㤥   ⮩ 1 )
 void OutTime (const char *str, unsigned long int t, char dot);

 // 뢮   祭 ६ t ( -  ᨬ ப,
 // ਬ, 'T' - ମ, 'R' - ମॣ)
 void OutTR (char c, int t);

 // 뢮    筨 祭 ५ (⠩, ମ-
 // ॣ  ..)
 void OutRSRC (char n);

 // 뢮   祭 ६ p (str - 砫 ᨬ,
 // ਬ, "B  " - ࠬ B ମ१; fi - ਧ ⮡ࠦ
 // ᫠  ଠ  䨪஢ 窮)
 void OutParamT (const char *str, unsigned int p, char fi);

 // 頥 1, ᫨     .
 char KeyPressed (void);

 //  祭 ⥪饣 ⠩
 void InputTimer (void);

 // 祭 ६ t (s - 砫 ᨬ, ਬ, "CLC";
 // a -   񭭮 祭   (᫨ a == -1,  
 // ந))
 void InputTime (unsigned long int *t, const char *s, int a);

 //  祭 ମॣ
 void InputTR (void);

 //  筨 祭 ५
 void InputRSRC (char n);

 //  祭 ଥ p (s - ਣ襭  , ਬ,
 // "B  ____"; fd - ᨬ쭮 祭  ࠬ,
 // nd - ⢮  , a -   񭭮 祭
 //  , fi - ਧ ⮡ࠦ ᫠  ଠ 
 // 䨪஢ 窮
 void InputParamT (unsigned int *p, const char *s, unsigned int mp,
                   char nd, char a, char fi);

 // 砥/몫砥 ५  ᨬ  ﭨ ணࠬ 稪
 void OutRelays (void);

 // 砥/몫砥 㦭 ᢥ⮤
 void OutLED (void);

 // 砥/몫砥 㪮 ᨣ  ࠡ뢠 ⠩, 㤨쭨,
 // 㯫    ..
 void OutSND (void);

 // 楤 ࠡ⪨ 뢠  ९ ⠩.  믮
 // ⮡ࠦ ଠ樨  , ᪠஢ ,
 //  ६,  ⠩஢, 祭 㪮 ᨣ  ..
 void interrupt Timer0 (void);

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//***************************** M A I N ***********************************
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

int main (void)
 {
  __CONFIG(XT & WDTDIS & PWRTEN & BORDIS & LVPDIS & DUNPROT & WRTDIS &
           DEBUGDIS & PROTECT);

  __IDLOC(0xFDA);


  __EEPROM_DATA(0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  __EEPROM_DATA(0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
  __EEPROM_DATA(0x00, 0x00, 0x00, 0x00, 0x62, 0x70, 0xAF, 0xFF);
  __EEPROM_DATA(0x00, 0x19, 0x0C, 0x68, 0x01, 0x26, 0x01, 0x2C);
  __EEPROM_DATA(0xCC, 0xCA, 0x27, 0x10, 0x27, 0x10,   30,   90);
  __EEPROM_DATA(  30,   50,   20, 0x00,   40, 0x00,   10, 0xFF);
  
  PORTA  = 0x00;
  PORTB  = 0x00;
  PORTC  = 0xF8;

  RBPU   = 0;
  T0CS   = 0;
  PSA    = 0;
  PS0    = 0;
  PS1    = 1;
  PS2    = 0;

  ADCON0 = 0x40;
  ADCON1 = 0x8E;

  TRISA  = 0x01;
  TRISB  = 0x07;
  TRISC  = 0x00;

  INTCON = 0x00;
  TMR0   = -245;
  T0IE   = 1;

  // 뢠 稪 ⠩஢
  for (i = 0; i <= 8; i++)
   _HMS [i] = ReadEEPROM16(i * 2);

  // 뢠 祭 㤨쭨
  AL = ((unsigned long int) ReadEEPROM16(AL_ADDR) << 16) |
        ReadEEPROM16(AL_ADDR + 2);

  // 뢠 権
  opt = ReadEEPROM16(OPT_ADDR);

  // 뢠 筨 祭 ५
  RSRC = ReadEEPROM16(RSRC_ADDR);

  // 뢠 ࠬ஢ ମॣ
  TReg = ReadEEPROM16(TREG_ADDR);
  BI = ReadEEPROM16(BI_ADDR);

  // 뢠 ࠬ஢ ମ१
  B  = ReadEEPROM16(B_ADDR);
  Rd = ReadEEPROM16(RD_ADDR);
  R0 = ReadEEPROM16(R0_ADDR);

  // 뢠 த⥫쭮 砭 㪮 ᨣ 
  // ࠡ뢠 ⠩
  Timer_D = ReadEEPROM16(TD_ADDR);

  // 뢠 த⥫쭮 砭 㪮 ᨣ 
  // ࠡ뢠 㤨쭨
  Alarm_D = ReadEEPROM16(AD_ADDR);

  // 뢠 த⥫쭮 砭 㪮 ᨣ 
  // ⨨  
  Beep_D = eeprom_read(BEEP_ADDR);

  // 뢠 ࢠ ६, १  ਡ  ⢨
  // ⨩   室  ० ᮢ
  TB = eeprom_read(TB_ADDR);

  // 뢠 ⢠ 㪮 祪,   ந
  //  ࠡ뢠 ⠩
  Timer_C = eeprom_read(TC_ADDR);

  // 뢠 ⢠ 㪮 祪,   ந
  //  ࠡ뢠 㤨쭨
  Alarm_C = eeprom_read(AC_ADDR);

  // 뢠 ६  "ॡ" ⠪⮢
  KPD = eeprom_read(KPD_ADDR);

  // 뢠 樥 ४樨 室 ᮢ
  CT = ReadEEPROM16(CORR_ADDR);

  GIE = 1;

  for (i = 0; i <= 8; i++)
   d [i] = od [i] = 0;

  refresh = 1;

  while (1)
   {
    if (VDD)
     {
      // ᫨ ⠭ 祭
      if (STOP)
       {
        STOP = 0;

        MODE = TIMER;

        ADON = 1;

        DelayUS(100);

        if (opt & HE)
         {
          // 뢮 ⠢
          opt = (SE | RTCE);

          FillD("FDA  2003");
          refresh = 1;
          DelayMS(750);

          for (i = 0; i <= 4; i++)
           {
            FillD(Hello [i]);
            refresh = 1;
            ds = 20;
            DelayMS(120);
           };

          DelayMS(250);

          for (i = 1; i <= 3; i++)
           {
            ds = 50;
            DelayMS(80);
           };

          DelayMS(250);

          opt = ReadEEPROM16(OPT_ADDR);
         };
       };

      OutSND();

      OutRelays();

      OutLED();

      if (opt & TEMPE)
       {
        if (adce >= 100)
         {
          adce = 0;

          if (ADON == 0)
           {
            ADON = 1;
            DelayUS(100);
           };

          ADGO = 1;
          while (ADGO);

          Ut = ((unsigned int)ADRESH << 8) | ADRESL;
         };
       }
      else ADON = 0;

      // ᫥ 祭 ⥬
      R0f = R0 / 1000.0;

      if ((R0 == 0) || (Rd == 0) || (B == 0) || (Ut < 67))
       Temp = -10000;
      else
       Temp = (int) (B / log(Rd / (1024.0 / Ut - 1) / R0f) - 273);
      
      if (KeyPressed()) // ᫨  - 
       if (cr > 0)
        {
         // ᫨  饭 㪮 ᨣ
         cr = 0;

         SND = 0;

         for (i = 0; i <= 8; i++)
          if (!SFR(i))
           _HMS [i] = ReadEEPROM16(i * 2);
        }
       else
        {
         // 祭  ⮩ 
         K = Key - 128;

         // 롮  ⠩
         if ((K >= '1') && (K <= '9'))
          {
           VT  = K - '1';
           MODE = TIMER;
          };

         // /몫
         if (K == 'V')
          {
           if (MODE == CLOCK) opt ^= (RTCE | ALE);

           if (MODE == ALARM)
            if (opt & RTCE) opt ^= ALE; else OutMessage(" CLC OFF ");

           if (MODE == TERM) opt ^= (TEMPE | TREGE);

           if (MODE == TREG)
            if (opt & TEMPE) opt ^= TREGE; else OutMessage("  TR OFF ");
          };

         // 
         if (K == '0')
          {
           if (MODE >= BEEP) MODE = CLOCK;
            else
             if (++MODE > CORR) MODE = TIMER;
          };

         // 樨
         if (K == 'O')
          {
           if (MODE < BEEP) MODE = BEEP;
            else
             if (++MODE > HELLO) MODE = TIMER;
          };

         // ମ/ମॣ
         if (K == 'T')
          {
           if (MODE < TERM) MODE = TERM;
            else
             if (++MODE > SET_RD) MODE = TIMER;
          };

         // 騩 
         if (K == 'A')
          {
           MODE = TIMER;
           nzt  = 0;

           j = SF;

           if (cnt > 250)
            while (cnt != 0);

           for (i = 0; i <= 8; i++)
            {
             _HMS [i] = ReadEEPROM16(i * 2);

             SFS(i,!j && (_HMS [i] > 0));
            };
          };

         // ⨢ 
         if (K == 'S')
          {
           MODE = TIMER;
           nzt  = 10;

           if (cnt > 250)
            while (cnt != 0);

           _HMS [VT] = ReadEEPROM16(VT * 2);

           SFS(VT,!SFR(VT) && (_HMS [VT] > 0));
          };

         // ⠭
         if (K == 'U')
          {
           if (SF == 0)
            switch (MODE)
             {
              case TIMER : InputTimer(); break;

              case CLOCK : opt |= RTCE; InputTime(&Ticks,"CLC __-__",-1); break;

              case ALARM : if (opt & RTCE)
                            {
                             opt |= ALE;
                             InputTime(&AL,"AL  __-__",AL_ADDR);
                            }
                           else OutMessage(" CLC OFF "); break;

              case CALIBRATE : if (opt & RTCE)
                                {
                                 Ticks -= Ticks % 60;
                                 cnt = 0;
                                } else OutMessage(" CLC OFF ");
                               break;

              case CORR : InputParamT(&CT,"CT ___   ",300,3,CORR_ADDR,0); break;

              case TERM : opt |= TEMPE; break;

              case TREG : if (opt & TEMPE)
                           {
                            opt |= TREGE;
                            InputTR();
                           }
                          else OutMessage("  TR OFF "); break;

              case SET_BI : InputParamT(&BI,"BI __",25,2,BI_ADDR,0); break;

              case SET_B : InputParamT(&B,"B  ____",9999,4,B_ADDR,0); break;

              case SET_R0 : InputParamT(&R0,"R0 ____",3000,4,R0_ADDR,1); break;

              case SET_RD : InputParamT(&Rd,"RD _____",62000,5,RD_ADDR,0); break;

              case R1_SRC : InputRSRC(0); break;

              case R2_SRC : InputRSRC(4); break;

              case R3_SRC : InputRSRC(8); break;

              case R4_SRC : InputRSRC(12); break;
             };

           switch (MODE)
            {
             case BEEP        : opt ^= BE;  break;
             case LED         : opt ^= LE;  break;
             case SOUND       : opt ^= SE;  break;
             case HEAT_COOL   : opt ^= HC;  break;
             case HELLO       : opt ^= HE;  break;
             case EVERY_CLOCK : opt ^= ECE; break;
            };
          };
        };

      // 뢮
      if (!refresh)
       {
        switch (MODE)
         {
          case TIMER : OutTimer(); break;

          case CLOCK : if (opt & RTCE) OutTime("CLC ",Ticks,1);
                        else FillD("CLC -- --"); break;

          case ALARM : if (opt & ALE) OutTime("AL  ",AL,0);
                        else FillD("AL  -- --"); break;

          case CALIBRATE : FillD("CALIB  ");
                           d [7] = (Ticks / 10) % 6;
                           d [8] = Ticks % 10;
                           break;

          case BEEP : if (opt & BE) FillD(" BEEP ON ");
                       else FillD(" BEEP OFF"); break;

          case LED : if (opt & LE) FillD(" LED ON  ");
                      else FillD(" LED OFF "); break;

          case SOUND : if (opt & SE) FillD(" SND ON  ");
                        else FillD(" SND OFF "); break;

          case R1_SRC : OutRSRC(0); break;

          case R2_SRC : OutRSRC(4); break;

          case R3_SRC : OutRSRC(8); break;

          case R4_SRC : OutRSRC(12); break;

          case HEAT_COOL : if (opt & HC) FillD(" TR HEAT ");
                            else FillD(" TR COOL "); break;

          case HELLO : if (opt & HE) FillD("HELLO ON ");
                        else FillD("HELLO OFF"); break;

          case EVERY_CLOCK : if (opt & ECE) FillD("  EC ON  ");
                              else FillD("  EC OFF "); break;

          case CORR : OutParamT("CT ",CT,0); break;

          case TERM : if (opt & TEMPE)
                       {
                        if (Temp == -10000) FillD("T  ERROR ");
                         else OutTR('T',Temp);
                       }
                      else FillD("T  --- `C"); break;

          case TREG : if (opt & TREGE) OutTR('R',TReg);
                       else FillD("R  --- `C"); break;

          case SET_BI : OutParamT("BI",BI,0); break;

          case SET_B : OutParamT("B",B,0); break;

          case SET_R0 : OutParamT("R0 ",R0,1); break;

          case SET_RD : OutParamT("RD ",Rd,0); break;
         };

        if (src != 2)
         {
          // 뢮 ஢ ࠡ⠢ ⠩஢
          if ((cr > 0) && ((cr % (2 * nr)) < nr) && (nzt <= 9))
           for (i = 0; i <= 8; i++)
            d [i] = (i < nzt) ? ZT [i] : ' ';

          //  ஬, ᫨ ࠡ⠫ - ⠩ 
          // 㤨쭨
          if ((cr > 0) && ((cr % (2 * nr)) >= nr))
           {
            if (src == 0)
             for (i = (nzt == 10); i <= 8; i++)
              d [i] = ' ';

            if (src == 1) d [0] = d [1] = ' ';
           };
         };

        //   
        refresh = 1;
       };
     }
    else
     // ᫨ 몫祭 ⠭
     if (!STOP)
      {
       STOP = 1;

       PORTC |= 0xF0;

       // ⠭ ࠬ " 㬮砭"
       for (i = 0; i <= 8; i++)
        {
         _HMS [i] = ReadEEPROM16(i * 2);
         d [i] = od [i] = ' ';
        };

       cr = nr = ds = SF = Key = TRO = i = 0;

       opt |= KE;

       MODE = CLOCK;

       ADGO = 0;
       ADON = 0;

       // ࠭ 権, ᫨  뫨 
       if (ReadEEPROM16(OPT_ADDR) != opt)
        {
         WriteEEPROM16(OPT_ADDR,opt);
         i = 1;
        };

       // ࠭ 筨 祭 ५, ᫨  뫨 
       if (ReadEEPROM16(RSRC_ADDR) != RSRC)
        {
         WriteEEPROM16(RSRC_ADDR,RSRC);
         i = 1;
        };

       if (i)
        {
         //   ᢥ⮤
         LEDG = 0;
         LEDR = 1;
        }
       else
        {
         //   ᢥ⮤
         LEDR = 0;
         LEDG = 1;
        };

       //  প
       for (i = 1; i <= 150; i++)
        {
         DelayUS(248);
         DelayUS(248);
         DelayUS(248);
         DelayUS(248);
        };

      // 몫 ᢥ⮤  ५
       LEDR = LEDG = RELE1 = RELE2 = RELE3 = RELE4 = SND = INF = 0;
       CLC = 1;
      };
   };
 };

//**************************************************************************
//==========================================================================
//**************************************************************************

 void SFS (char n, char v)
  {
   SF = (SF & ~(1 << n)) | (v << n);
  };

//**************************************************************************

 char SFR (char n)
  {
   return (SF & (1 << n)) > 0;
  };

//**************************************************************************

 void itoa10 (long int i)
  {
   char l = 0, t, n;

   if (i == 0) s [l++] = '0'; else
    {
     if (i < 0)
      {
       s [l++] = '-';
       i = -i;
      };

     while (i > 0)
      {
       s [l++] = (i % 10) + '0';
       i /= 10;
      };

     i = (s [0] == '-');

     for (n = 0; n < (l - i) / 2; n++)
      {
       t = s [n + i];
       s [n + i] = s [l - n - 1];
       s [l - n - 1] = t;
      };
    };

   s [l] = 0;
  };

//**************************************************************************

 void WriteEEPROM16 (char a, unsigned int v)
  {
   eeprom_write(a,v >> 8);
   eeprom_write(a + 1,v & 0xFF);
  };

//**************************************************************************)

 unsigned int ReadEEPROM16 (char a)
  {
   return ((unsigned int) eeprom_read(a) << 8) | eeprom_read(a + 1);
  };

//**************************************************************************)

 char Syms (char c)
  {
   switch (c)
    {
     case  0  : return 0xDE;
     case  1  : return 0x50;
     case  2  : return 0x4F;
     case  3  : return 0x5B;
     case  4  : return 0xD1;
     case  5  : return 0x9B;
     case  6  : return 0x9F;
     case  7  : return 0x58;
     case  8  : return 0xDF;
     case  9  : return 0xDB;
     case '0' : return 0xDE;
     case '1' : return 0x50;
     case '2' : return 0x4F;
     case '3' : return 0x5B;
     case '4' : return 0xD1;
     case '5' : return 0x9B;
     case '6' : return 0x9F;
     case '7' : return 0x58;
     case '8' : return 0xDF;
     case '9' : return 0xDB;
     case 'A' : return 0xDD;
     case 'B' : return 0x97;
     case 'C' : return 0x8E;
     case 'D' : return 0x57;
     case 'E' : return 0x8F;
     case 'F' : return 0x8D;
     case 'H' : return 0xD5;
     case 'I' : return 0x50;
     case 'L' : return 0x86;
     case 'N' : return 0xDC;
     case 'O' : return 0xDE;
     case 'P' : return 0xCD;
     case 'R' : return 0x05;
     case 'S' : return 0x9B;
     case 'T' : return 0x87;
     case 'U' : return 0xD6;
     case '-' : return 0x01;
     case '_' : return 0x02;
     case '`' : return 0xC9;
    };
 
   return 0;
  };

//**************************************************************************)

 char Decode (char c)
  {
   switch (c)
    {
     case  5  : return '0';
     case  13 : return '1';
     case  12 : return '2';
     case  10 : return '3';
     case  15 : return '4';
     case  14 : return '5';
     case  11 : return '6';
     case  7  : return '7';
     case  6  : return '8';
     case  3  : return '9';
     case  0  : return 'A';
     case  8  : return 'S';
     case  9  : return 'O';
     case  1  : return 'U';
     case  2  : return 'V';
     case  4  : return 'T';
     default  : return 0;
    };
  };

//**************************************************************************)

 void SetNR (char n)
  {
   char nn = 0;

   if (n & 8) nn |= 1;
   if (n & 4) nn |= 2;
   if (n & 2) nn |= 4;
   if (n & 1) nn |= 8;

   PORTC = (PORTC & 0x0F) | (nn << 4);
  };

//**************************************************************************)

 void SetDIG (char n)
  {
   char i, d;

   d = Syms(n & 0x7F) | ((n >= 128) << 5);

   SetNR(15);

   for (i = 0; i <= 7; i++)
    {
     CLC = 0;
     INF = (d & 1);
     CLC = 1;
     d >>= 1;
    };
  };

//**************************************************************************

 void FillD (const char *s)
  {
   char i;

   for (i = 0; i <= 8; i++)
    if (i < strlen(s)) d [i] = s [i]; else d [i] = ' ';
  };

//**************************************************************************

 void DelayMS (unsigned int cnt)
  {
   opt &= ~KE;

   while ((cnt-- > 0) && VDD)
    {
     DelayUS(247);
     DelayUS(247);
     DelayUS(247);
     DelayUS(247);
    };

   opt |= KE;
  };

//**************************************************************************

 void OutMessage (const char *s)
  {
   FillD(s);
   refresh = 1;
   DelayMS(500);
  };

//**************************************************************************

 void OutTimer (void)
  {
   d [0] = VT + 1;
   d [1] = ' ';
   d [2] =   _HMS [VT] / 3600;
   d [3] = '-';
   d [4] = ((_HMS [VT] / 60) % 60) / 10;
   d [5] = ( _HMS [VT] / 60) % 10;
   d [6] = '-';
   d [7] = ( _HMS [VT] % 60) / 10;
   d [8] =   _HMS [VT] % 10;
  };

//**************************************************************************

 void OutTime (const char *str, unsigned long int t, char dot)
  {
   FillD(str);
   d [4] = t / 36000;
   d [5] = (t / 3600) % 10;
   d [6] = '-';
   d [7] = (t / 600) % 6;
   d [8] = (t / 60) % 10 + 32 * ((cnt <= 250) && dot);
  };

//**************************************************************************

 void OutTR (char c, int t)
  {
   char i;

   itoa10(t);

   d [0] = c;
   d [1] = d [6] = ' ';

   for (i = 0; i < strlen(s); i++)
    d [6 - strlen(s) + i] = s [i];

   for (i = 0; i < 4 - strlen(s); i++)
    d [2 + i] = ' ';

   d [7] = '`';
   d [8] = 'C';
  };

//**************************************************************************

 void OutRSRC (char n)
  {
   FillD("RELE_    ");
   d [4] = (n / 4) + 1;

   if (((RSRC >> n) & 0x0F) != 12)
    switch ((RSRC >> n) & 0x0F)
     {
      case 10 : d [7] = 'A'; d [8] = 'T'; break;
      case 11 : d [7] = 'T'; d [8] = 'R'; break;
      default : d [7] = 'T'; d [8] = ((RSRC >> n) & 0x0F); break;
     }
   else
    {
     d [6] = 'O';
     d [7] = 'F';
     d [8] = 'F';
    };
  };

//**************************************************************************

 void OutParamT (const char *str, unsigned int p, char fi)
  {
   char i, e = 0;

   FillD(str);

   itoa10(p);

   if (fi && (p < 1000))
    {
     e = 1;
     d [3] = 0;
    };

   for (i = 0; i < strlen(s); i++)
    d [3 + i + e] = s [i];

   for (i = strlen(s) + 3 + e; i <= 8; i++)
    d [i] = ' ';

   if (fi) d [3] += 128;
  };

//**************************************************************************)

 char KeyPressed (void)
  {
   char tmp;

   tmp = Key;

   if ((tmp > 0) && (tmp < 128))
    {
     opt &= ~KE;
     Key = tmp + 128;
     opt |= KE;
     DelayMS(KPD);
     return 1;
    }
   else return 0;
  };

//**************************************************************************

 void InputTimer (void)
  {
   char i, npv = 0;

   mtmp = MODE;
   MODE = NO_MODE;

   FillD("  _-__-__");

   d [0] = VT + 1;

   do
    {
     if (KeyPressed())
      {
       K = Key - 128;

       if ((npv % 2) == 0)
        {
         if ((K >= '0') && (K <= '9'))
          {
           switch (npv)
            {
             case 0 : i = 2; break;
             case 2 : i = 5; break;
             case 4 : i = 8; break;
            };

           d [i] = K - '0';
           npv++;
          };
        }
       else
        if ((K >= '0') && (K <= '5'))
         {
          if (npv == 1) i = 4; else i = 7;
          d [i] = K - '0';
          npv++;
         };

       if (npv == 5)
        _HMS [VT] = d [8] + 10U * d [7] + 60U * (d [5] + 10U * d [4]) +
                    3600U * d [2];

       if (K == 'V')
        {
         _HMS [VT] = 0;
         d [2] = d [4] = d [5] = d [7] = d [8] = 0;
         d [0] = VT + 1;
         npv = 5;
        };

       if ((npv == 5) || (K == 'U')) MODE = EXIT_MODE;
      };

     refresh = 1;
    } while ((MODE == NO_MODE) && VDD);

   MODE = mtmp;

   if (VDD)
    if (npv == 5) WriteEEPROM16(VT * 2,_HMS [VT]);
     else OutMessage("  NO SET ");
  };

//**************************************************************************

 void InputTime (unsigned long int *t, const char *s, int a)
  {
   char npv = 4;

   mtmp = MODE;
   MODE = NO_MODE;

   FillD(s);

   do
    {
     if (KeyPressed())
      {
       K = Key - 128;

       if ((npv == 4) && (K >= '0') && (K <= '2'))
        d [npv++] = K - '0';
         else
          if ((npv == 5) && (K >= '0') && (K <= '9') &&
              ((d [4] * 10 + K - '0') <= 23))
           d [npv++] = K - '0';
            else
             if ((npv == 6) && (K >= '0') && (K <= '5'))
              d [++npv] = K - '0';
               else
                if ((npv == 7) && (K >= '0') && (K <= '9'))
                 d [++npv] = K - '0';

       if (npv == 8)
        *t = (10UL * d [4] + d [5]) * 3600UL + (10UL * d [7] + d [8]) * 60UL;

       if (K == 'V')
        {
         *t = 0;
         d [4] = d [5] = d [7] = d [8] = 0;
         npv = 8;
        };

       if ((npv == 8) || (K == 'U')) MODE = EXIT_MODE;
      };

     refresh = 1;
    } while ((MODE == NO_MODE) && VDD);

   MODE = mtmp;

   if (VDD)
    if (npv == 8)
     {
      if (a > 0)
       {
        WriteEEPROM16(a,*t >> 16);
        WriteEEPROM16(a + 1,*t & 0xFFFF);
       };
     }
    else OutMessage("  NO SET ");
  };

//**************************************************************************

 void InputTR (void)
  {
   char npv = 3;

   mtmp = MODE;
   MODE = NO_MODE;

   FillD("R  ___ `C");

   do
    {
     if (KeyPressed())
      {
       K = Key - 128;

       if ((npv == 3) && (((K >= '0') && (K <= '9')) || (K == 'V')))
        {
         d [npv++] = (K == 'V') ? '-' : K - '0';
         if (K == '0') npv = 100;
        }
       else
        if (npv == 4)
         {
          if (d [3] == '-')
           {
            if ((K >= '0') && (K <= '9'))
             {
              d [npv++] = K - '0';
              if (K == '0') npv = 100;
              if (K > '4')  npv = 101;
             };
           }
          else
           if ((K >= '0') && (K <= '9'))
            {
             d [npv++] = K - '0';
             if (d [3] * 10 + d [4] > 47) npv = 102;
            };
         }
        else
         if (npv == 5)
          {
           if (d [3] == '-')
            {
             if ((K >= '0') && (K <= '9') &&
                 ((d [4] * 10 + K - '0') <= 43))
              d [npv++] = K - '0';
            }
           else
            if ((K >= '0') && (K <= '9') &&
                ((d [3] * 100UL + d [4] * 10 + K - '0') <= 470))
             d [npv++] = K - '0';
          };

       if (npv == 6)
        {
         if (d [3] == '-') TReg = -(d [4] * 10 + d [5]);
          else TReg = d [3] * 100UL + d [4] * 10UL + d [5];
         npv = 200;
        };

       if (npv == 100)
        {
         TReg = 0;
         npv = 200;
        };

       if (npv == 101)
        {
         TReg = -d [4];
         npv = 200;
        };

       if (npv == 102)
        {
         TReg = d [3] * 10 + d [4];
         npv = 200;
        };

       if ((npv > 3) && (K == 'U'))
        {
         npv = 200;

         if (d [3] == '-')
          {
           if (d [4] != '_') TReg = -d [4]; else MODE = EXIT_MODE;
          }
         else
          if (d [4] == '_') TReg = d [3]; else TReg = d [3] * 10 + d [4];
        };

       if ((npv == 200) || (K == 'T') || ((K == 'U') && (npv == 3)))
        MODE = EXIT_MODE;
      };

     refresh = 1;
    } while ((MODE == NO_MODE) && VDD);

   MODE = mtmp;

   if (VDD)
    if (npv == 200) WriteEEPROM16(TREG_ADDR,TReg);
     else OutMessage("  NO SET ");
  };

//**************************************************************************

 void InputRSRC (char n)
  {
   char e = 0;

   mtmp = MODE;
   MODE = NO_MODE;

   FillD("RELE_   _");
   d [4] = (n / 4) + 1;

   do
    {
     if (KeyPressed())
      {
       K = Key - 128;

       if (((K >= '1') && (K <= '9')) ||
           (K == 'A') || (K == 'T') || (K == 'V'))
        {
         RSRC &= ~(15U << n);

         if ((K >= '1') && (K <= '9'))
          RSRC |= ((unsigned int) (K - '0') << n);
         else
          if (K == 'A') RSRC |= (10U << n);
           else
            if (K == 'T') RSRC |= (11U << n);
             else RSRC |= (12U << n);

         e = 1;
        };

       if (e || (K == 'O') || (K == 'U')) MODE = EXIT_MODE;
      };

     refresh = 1;
    } while ((MODE == NO_MODE) && VDD);

   MODE = mtmp;

   if (VDD && !e) OutMessage("  NO SET ");
  };

//**************************************************************************

 void InputParamT (unsigned int *p, const char *s, unsigned int mp,
                   char nd, char a, char fi)
  {
   char i, npv = 3;
   unsigned long int m, t;

   nd += 3;

   mtmp = MODE;
   MODE = NO_MODE;

   FillD(s);

   if (fi) d [3] += 128;

   do
    {
     if (KeyPressed())
      {
       K = Key - 128;

       if ((K >= '0') && (K <= '9'))
        {
         t = 0;

         if (!fi)
          {
           m = 10;

           for (i = npv - 1; i >= 3; i--)
            {
             t += (d [i] * m);
             m *= 10;
            };

           t += (K - '0');
          }
         else
          {
           m = 1000;

           for (i = 3; i < npv; i++)
            {
             t += ((d [i] - 128 * (i == 3)) * m);
             m /= 10;
            }

           t += ((K - '0') * m);
          };

         if (t <= mp)
          {
           d [npv++] = K - '0';

           if ((npv == 4) && fi) d [3] += 128;

           if ((npv == 4) && (K == '0') && !fi)
            {
             *p = 0;
             npv = 100;
            };
          };
        };

       if ((npv == nd) || ((npv > 3) && (K == 'U')))
        {
         *p = 0;

         if (!fi)
          {
           m = 1;

           for (i = npv - 1; i >= 3; i--)
            {
             *p += (d [i] * m);
             m *= 10;
            };
          }
         else
          {
           m = 1000;

           for (i = 3; i < npv; i++)
            {
             *p += ((d [i] - 128 * (i == 3)) * m);
             m /= 10;
            }
          };

         npv = nd;
        };

       if ((npv == 100) || (npv == nd) || (K == 'T') ||
           ((K == 'U') && (npv == 3)))
        MODE = EXIT_MODE;
      };

     refresh = 1;
    } while ((MODE == NO_MODE) && VDD);

   MODE = mtmp;

   if (VDD)
    if (npv >= nd) WriteEEPROM16(a,*p);
     else OutMessage("  NO SET ");
  };

//**************************************************************************

 void OutRelays (void)
  {
   i = 0;

   do
    {
     if (((RSRC >> i) & 0x0F) != 12)
      {
       switch ((RSRC >> i) & 0x0F)
        {
         case 10 : j = SF > 0; break;

         case 11 : if (Temp <= (TReg - (BI / 2))) TRO = 1;
                   if (Temp >= (TReg + (BI / 2))) TRO = 0;
                   j = (opt & HC) ? TRO : !TRO; break;

         default : j = SFR((RSRC >> i) & 0x0F); break;
        };

       switch (i)
        {
         case 0  : RELE1 = j; break;
         case 4  : RELE2 = j; break;
         case 8  : RELE3 = j; break;
         case 12 : RELE4 = j; break;
        };
      };

     i += 4;
    } while (i != 16);
  };

//**************************************************************************

 void OutLED (void)
  {
   if ((SF > 0) && (opt & LE) && (cnt <= 250))
    {
     LEDR = RSRC != 0xCCCC;
     LEDG = RSRC == 0xCCCC;
    }
   else
    LEDR = LEDG = 0;
  };

//**************************************************************************

 void OutSND (void)
  {
   if (cr == -1)
    {
     cr = 0;

     SND = 0;

     for (i = 0; i <= 8; i++)
      if (!SFR(i))
       _HMS [i] = ReadEEPROM16(i * 2);
    };

   if ((Ticks == AL) && (opt & ALE) && (cr == 0))
    {
     nr   = (cr = Alarm_D) / (2 * Alarm_C - 1);
     src  = 1;
     MODE = ALARM;
    };

   if (newsec)
    {
     newsec = 0;

     if (((Ticks % 3600) == 0) && (opt & RTCE) &&
          (opt & ECE) && (SF == 0)) ds = 150;

     for (i = 0; i <= 8; i++)
      if (SFR(i))
       {
        if (--_HMS [i] == 0)
         {
          VT   = i;
          nr   = (cr = Timer_D) / (2 * Timer_C - 1);
          MODE = TIMER;
          src  = 0;
          SFS(i,0);
          if (nzt < 9) ZT [nzt++] = i + 1;
         };
       };
    };
  };

//**************************************************************************

 void interrupt Timer0 (void)
  {
   static char i, tmp;

   TMR0 = -245;
   T0IF = 0;

   adce++;

   for (i = CT; i > 0; i--);

   if (!STOP)
    {
     if ((refresh) && (nvd == 0))
      {
       refresh = 0;

       for (i = 0; i <= 8; i++)
        od [i] = d [i];
      };

     if (nvd == 7) SetDIG(od [0]);
      else
       if (nvd == 8) SetDIG(od [1]);
        else SetDIG(od [8 - nvd]);

     SetNR(nvd);

     if ((nvd < 8) && (opt & KE))
      {
       if (Key > 128)
        {
         tmp = Key - 128;

         if (((tmp == Decode(nvd)) && (Keys1 == 1)) ||
             ((tmp == Decode(nvd + 8)) && (Keys2 == 1))) Key = 0;
        }
       else
        {
         if (Keys1 == 0) Key = Decode(nvd);
         if (Keys2 == 0) Key = Decode(nvd + 8);

         if (Key > 0)
          {
           kp = 0;
           if (opt & BE) ds = Beep_D;
          };
        };
      };

     if (nvd < 8) nvd++; else nvd = 0;

     if (ds > 1)  SND = 1;
     if (ds > 0)  ds--;
     if (ds == 1) SND = 0;

     if ((cr > 0) && (ds == 0))
      if (opt & SE)
       {
        if ((cr % nr) == 0) SND = 1;
        if ((cr % (2 * nr)) == 0) SND = 0;
       }
      else
       SND = 0;

     if (cr > 0) cr--;

     if (cr == 1) cr = -1;
    };

   if (++cnt == 500)
    {
     cnt = 0;
     newsec = 1;

     if (opt & RTCE) Ticks++;

     if (Ticks == 86400) Ticks = 0;

     if (!STOP)
      {
       if (kp < TB) kp++;
        else
         if ((MODE != TERM) && (SF == 0) && (cr == 0) && (opt & RTCE))
          MODE = CLOCK;
         else kp = 0;
      };
    };
  };
