;********************************************************
;
;              DC motor speed controller
;
;                                 Divice : PIC16F873
;                                 Author : Seiichi Inoue
;********************************************************

        list            p=pic16f873
        include         p16f873.inc
       __config _hs_osc & _wdt_off & _pwrte_on & _lvp_off
        errorlevel      -302    ;Suppress bank warning

;****************  Label Definition  ********************
speed   equ     d'8'   ;Reference speed (5x8/256=0.156V)
change  equ     d'1'    ;Change value (2mV/ms)

led     equ     h'20'   ;LED control data save area

;****************  Program Start  ***********************
        org     0               ;Reset Vector
        goto    init
        org     4               ;Interrupt Vector
        goto    int

;****************  Initial Process  *********************
init

;*** Port initialization
        bsf     status,rp0      ;Change to Bank1
        movlw   b'00000001'     ;AN0 to input mode
        movwf   trisa           ;Set TRISA register
        clrf    trisb           ;Set TRISB to uotput mode
        clrf    trisc           ;Set TRISC to output mode
        bcf     status,rp0      ;Change to Bank0

;*** A/D converter initialization
        movlw   b'10000001'     ;ADCS=10 CHS=AN0 ADON=ON
        movwf   adcon0          ;Set ADCON0 register
        bsf     status,rp0      ;Change to Bank1
        movlw   b'00001110'     ;ADFM=0 PCFG=1110
        movwf   adcon1          ;Set ADCON1 register
        bcf     status,rp0      ;Change to Bank0

;*** PWM initialization
        clrf    tmr2            ;Clear TMR2 register
        movlw   b'11111111'     ;Max duty (low speed)
        movwf   ccpr1l          ;Set CCPR1L register
        bsf     status,rp0      ;Change to Bank1
        movlw   d'255'          ;Period=1638.4usec(610Hz)
        movwf   pr2             ;Set PR2 register
        bcf     status,rp0      ;Change to Bank0
        movlw   b'00000110'     ;Pst=1:1 TMR2=ON Pre=1:16
        movwf   t2con           ;Set T2CON register
        movlw   b'00001100'     ;CCP1XY=0 CCP1M=1100(PWM)
        movwf   ccp1con         ;Set CCP1CON register

;*** Compare mode initialization
        clrf    tmr1h           ;Clear TMR1H register
        clrf    tmr1l           ;Clear TMR1L register
        movlw   h'61'           ;H'61A8'=25000
        movwf   ccpr2h          ;Set CCPR2H register
        movlw   h'a8'           ;25000*0.4usec = 10msec
        movwf   ccpr2l          ;Set CCPR2L register
        movlw   b'00000001'     ;Pre=1:1 TMR1=Int TMR1=ON
        movwf   t1con           ;Set T1CON register
        movlw   b'00001011'     ;CCP2M=1011(Compare)
        movwf   ccp2con         ;Set CCP2CON register

;*** Interruption control
        bsf     status,rp0      ;Change to Bank1
        movlw   b'00000001'     ;CCP2IE=Enable
        movwf   pie2            ;Set PIE2 register
        bcf     status,rp0      ;Change to Bank0
        movlw   b'11000000'     ;GIE=ON PEIE=ON
        movwf   intcon          ;Set INTCON register

wait
        goto    $               ;Interruption wait

;***************  Interruption Process  *****************
int
        clrf    pir2            ;Clear interruption flag
ad_check
        btfsc   adcon0,go       ;A/D convert end ?
        goto    ad_check        ;No. Again
        movfw   adresh          ;Read ADRESH register
        sublw   speed           ;Ref speed - Detect speed
        btfsc   status,c        ;Reference < Detect ?
        goto    check1          ;No. Jump to > or = check

;--- control to low speed ---
        movfw   ccpr1l          ;Read CCPR1L register
        addlw   change          ;Change value + CCPR1L
        btfss   status,c        ;Overflow ?
        movwf   ccpr1l          ;No. Write CCPR1L
        goto    led_cont        ;Jump to LED control

check1
        btfsc   status,z        ;Reference = Detect ?
        goto    led_cont        ;Yes. Jump to LED control

;--- control to fast speed ---
        movlw   change          ;Set change value
        subwf   ccpr1l,f        ;CCPR1L - Change value
        btfsc   status,c        ;Underflow ?
        goto    led_cont        ;Jump to LED control
        clrf    ccpr1l          ;Set fastest speed

;****************  LED control Process ******************
led_cont
        comf    ccpr1l,w        ;Complement CCPR1L bit
        movwf   led             ;Save LED data
        movlw   b'00010000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led1            ;No. 
        movlw   b'00000000'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led1    movlw   b'00100000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led2            ;No. 
        movlw   b'00000001'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led2    movlw   b'01000000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led3            ;No. 
        movlw   b'00000011'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led3    movlw   b'01100000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led4            ;No. 
        movlw   b'00000111'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led4    movlw   b'10000000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led5            ;No. 
        movlw   b'00001111'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led5    movlw   b'10100000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led6            ;No. 
        movlw   b'00011111'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led6    movlw   b'11000000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led7            ;No. 
        movlw   b'00111111'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led7    movlw   b'11100000'     ;Set compare data
        subwf   led,w           ;LED - data
        btfsc   status,c        ;Under ?
        goto    led8            ;No. 
        movlw   b'01111111'     ;Set LED control data
        goto    int_end         ;Jump to interrupt end
led8    movlw   b'11111111'     ;Set LED control data

;************  END of Interruption Process **************
int_end
        movwf   portb           ;Set PROTB
        retfie

;********************************************************
;            END of DC motor speed controller
;********************************************************

        end
