// **********************************************
// *       -     *
// **********************************************
// * :              ..              *
// *  :  WinAVR (GCC v1.4.2)     *
// * :         Atmega8                 *
// *                         kotov_ig@mail.ru   *
// **********************************************

#include <avr/io.h>
#include <string.h>
#include <avr/wdt.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/delay.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#define K0      PC0
#define K1      PC1
#define K2      PC2
#define MODE    PC3
#define DN      PC4
#define UP      PC5
#define IN1     PB0
#define IN2     PB1
#define GR2     PB2
#define RD2     PB3
#define GR1     PB4
#define RD1     PB5
#define OUT1    PB6
#define OUT2    PB7
#define SetRed1()    PORTB |= _BV(RD1); PORTB &= ~_BV(GR1);
#define SetGreen1()  PORTB |= _BV(GR1); PORTB &= ~_BV(RD1);
#define SetYellow1() PORTB |= _BV(GR1)|_BV(RD1);
#define ResetLed1()  PORTB &= ~(_BV(GR1)|_BV(RD1));
#define SetRed2()    PORTB |= _BV(RD2); PORTB &= ~_BV(GR2);
#define SetGreen2()  PORTB |= _BV(GR2); PORTB &= ~_BV(RD2);
#define SetYellow2() PORTB |= _BV(GR2)|_BV(RD2);
#define ResetLed2()  PORTB &= ~(_BV(GR2)|_BV(RD2));

   //   status 
#define comma     0
#define qwsec     1
#define termost1  2
#define termost2  3
#define gist1     4
#define gist2     5
#define mode      6
#define change    7

   //   klav
#define UP1       0
#define UP2       1
#define DN1       2
#define DN2       3
#define MODE1     4
#define MODE2     5

unsigned char _osccal  EEMEM  = 0xAF;
unsigned char _status  EEMEM  = 0x00;
unsigned char _ust1[5] EEMEM  = {0x00,0x03,0x00,0x00,0x00};
unsigned char _ust2[5] EEMEM  = {0x00,0x03,0x00,0x00,0x00};
unsigned char _dlt1[2] EEMEM  = {0x00,0x00};
unsigned char _dlt2[2] EEMEM  = {0x00,0x00};
unsigned char _cor1[3] EEMEM  = {0x00,0x00,0x00};
unsigned char _cor2[3] EEMEM  = {0x00,0x00,0x00};

unsigned char encod[19+8]  = {0xC0,0xF9,0xA4,0xB0,0x99,0x92,0x82,0xF8,0x80,
                              0x90,0x86,0xAF,0xA3,0xA1,0xE3,0xA7,0x87,0xFF,0xBF, //0,1,2,3,4,5,6,7,8,9,E,r,o,d,u,c,t,SPASE,-
							  0xFC,0xBD,0xAF,0xE7,0xF3,0xBB,0x9F,0xDE};
unsigned char ust1[5];
unsigned char ust2[5];
unsigned char dlt1[2];
unsigned char dlt2[2];
unsigned char cor1[3];
unsigned char cor2[3];
unsigned char temp1[5];
unsigned char temp2[5];
unsigned char buftemp1[3];
unsigned char buftemp2[3];
unsigned char ind[3];
unsigned char status,st;
unsigned char klav;
unsigned char picter;
unsigned char dgcnt,snkcnt,concnt,modcnt,chncnt;
unsigned char cntUP,cntDN,cntMODE;
signed int    temprary;
signed int    tempr1,tempr2,mintempr1,maxtempr1,mintempr2,maxtempr2;

 
enum {TEMP1,TEMP2,UST1,UST2,DLT1,DLT2,COR1,COR2,IND_US1,
                IND_US2,IND_DT1,IND_DT2,IND_CO1,IND_CO2};

void Conver1 (void) //     1
{
 asm volatile
	(
	
	"           clt"                   "\n\t"
	"           rcall ResetLan1" 	   "\n\t"
	"           brts fn11"              "\n\t"
	"           ldi r18,0xcc"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"           ldi r18,0x4e"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"           ldi r18,0x7d"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"           ldi r18,0x77"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"           ldi r18,0x7f"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"           rcall ResetLan1" 	   "\n\t"
	"           brts fn11"             "\n\t"
	"           ldi r18,0xcc"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"           ldi r18,0x44"          "\n\t"
	"           rcall WriteByte1"      "\n\t"
	"fn11:      rjmp EndFuncCon1" 	   "\n\t"
	
	"ResetLan1: sbi %a3,%a1 "    	   "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"	       "\n\t"   //PORT_IO,DIO
	"           ldi  r16,230"          "\n\t"   //700uS
	"           rcall Del1"             "\n\t"
	"           cbi %a3,%a1 "    	   "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"	       "\n\t"   //PORT_IO,DIO
	"           ldi  r16,10"           "\n\t"
	"           rcall Del1"             "\n\t"
	"           sbic %a2,%a1"          "\n\t"
	"           set"                   "\n\t"
    "           ldi  r16,160"          "\n\t"   //500uS
	"           rcall Del1"             "\n\t"
	"           sbis %a2,%a1"          "\n\t"
	"           set"                   "\n\t"
	"           ret"                   "\n\t"
	
	"ReadSlot1:  sbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           nop"                   "\n\t"   //2uS
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
    "           cbi %a3,%a1 " 	       "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           ldi  r16,3"            "\n\t"   //13uS
	"           rcall Del1"             "\n\t"
	"           clc"                   "\n\t"
	"           sbic %a2,%a1"          "\n\t"   //PIN_IO,DIO
	"           sec"            	   "\n\t"
	"           ldi  r16,20"   	       "\n\t"   //60uS
	"           rcall Del1"      	   "\n\t"
	"           ret"            	   "\n\t"
	
	"WriteLow1: sbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           ldi  r16,25"           "\n\t"   //80uS
	"           rcall Del1"             "\n\t"
	"           cbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"  	       "\n\t"   //PORT_IO,DIO
	"           ret"                   "\n\t"
	
	"WriteHigh1: sbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           nop"                   "\n\t"   //2uS
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           cbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"  	       "\n\t"   //PORT_IO,DIO
	"           ldi  r16,23"    	   "\n\t"   //75uS
	"           rcall Del1"      	   "\n\t"
	"           ret"           	       "\n\t"
	
	"ReadByte1:  ldi r17,8"     	       "\n\t"
	"           in __tmp_reg__,__SREG__""\n\t"
	"           clr r18"               "\n\t"
	"           cli"                   "\n\t"
	"rb11:       rcall ReadSlot1"        "\n\t"
	"           ror r18"               "\n\t"
	"           dec r17"               "\n\t"
	"           brne rb11"              "\n\t"
	"           out __SREG__,__tmp_reg__""\n\t"
	"           ret"                   "\n\t"
	
	"WriteByte1: ldi r17,8"             "\n\t"
	"           in __tmp_reg__,__SREG__""\n\t"
	"           cli"                   "\n\t"
	"wb11:       ror r18"               "\n\t"
	"           brcc wb21"              "\n\t"
	"           rcall WriteHigh1"       "\n\t"
	"           rjmp wb31"              "\n\t"
	"wb21:       rcall WriteLow1"        "\n\t"
	"wb31:       dec r17"               "\n\t"
	"           brne wb11"  			   "\n\t"
	"           out __SREG__,__tmp_reg__""\n\t"
	"           ret"           		   "\n\t"
	
	
	"Del1:       push r16"              "\n\t"
	"dl11:       dec r16"               "\n\t"
	"           brne dl11"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl21:       dec r16"               "\n\t"
	"           brne dl21"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl31:       dec r16"               "\n\t"
	"           brne dl31"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl4:       dec r16"               "\n\t"
	"           brne dl4"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl51:       dec r16"               "\n\t"
	"           brne dl51"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl61:       dec r16"               "\n\t"
	"           brne dl61"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl71:       dec r16"               "\n\t"
	"           brne dl71"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl81:       dec r16"               "\n\t"
	"           brne dl81"              "\n\t"
	"           pop r16"               "\n\t"
	"           ret"                   "\n\t"
	
	"EndFuncCon1: nop"                   "\n\t"
	
	:
	:"I" (0x18),
     "I" (0),
     "I" (0x16),
     "I" (0x17)
	:"r16","r17","r18","r19"
	);
}

void Result1 (void *res_lan) //    1
{
  asm volatile
	(
	
	"           rcall ResetLan1" 	   "\n\t"
	"           brts Error1"            "\n\t"
	"           ldi r18,0xcc"          "\n\t"
	"           rcall WriteByte1"       "\n\t"
	"           ldi r18,0xbe"          "\n\t"
	"           rcall WriteByte1"       "\n\t"
	"           rcall ReadByte1"        "\n\t"
    "           mov r19,r18"           "\n\t"
	"           rcall ReadByte1"        "\n\t"
    "           adiw r30,4"            "\n\t"
	"           clr  r16"              "\n\t"
	"           st  %a0,r16"           "\n\t"
	"           tst r18 "              "\n\t"
	"           brpl rs11"              "\n\t"
    "           com r19"               "\n\t"
	"           subi r19,1"             "\n\t"
	"           com r18"               "\n\t"
	"           sbci r18,0"             "\n\t"
	"           ser  r16"              "\n\t"
	"           st   %a0,r16"          "\n\t"
	"rs11:      ldi  r16,0x07"         "\n\t"
	"           and  r18,r16"          "\n\t"
	"           ldi  r16,0x0f"         "\n\t"
	"           swap r18"              "\n\t"
	"           mov  r17,r19"          "\n\t"
	"           swap r19"              "\n\t"
	"           and  r19,r16"          "\n\t"
    "           and  r17,r16"          "\n\t"
	"           or   r18,r19"          "\n\t"
    "           ldi  r19,10"           "\n\t"
    "           mul  r17,r19"          "\n\t"
	"           swap __tmp_reg__"      "\n\t"
	"           and  r16,__tmp_reg__"  "\n\t"
	"           subi r16,0"            "\n\t" // -0,0C
	"           st   -%a0,r16"         "\n\t"
	"           eor __zero_reg__,__zero_reg__" "\n\t"
	"rs21:       subi r18,10 "          "\n\t"
	"           inc  __zero_reg__"     "\n\t"
	"           brcc rs21"              "\n\t"
	"           dec  __zero_reg__"     "\n\t"
	"           subi r18,0xf6"         "\n\t"
	"           st   -%a0,r18"         "\n\t"
	"           mov  r18,__zero_reg__" "\n\t"
	"           eor __tmp_reg__,__tmp_reg__" "\n\t"
	"rs31:       subi r18,10 "          "\n\t"
	"           inc  __tmp_reg__"      "\n\t"
	"           brcc rs31"              "\n\t"
	"           dec  __tmp_reg__"      "\n\t"
	"           subi r18,0xf6"         "\n\t"
    "           st   -%a0,r18"         "\n\t"
	"           st   -%a0,__tmp_reg__" "\n\t"
	"           rjmp EndFuncRes1"       "\n\t"

	"Error1:     clt"                   "\n\t"
	"           ldi r18,0x0f"          "\n\t"   //'?'
	"           st   %a0+,r18"         "\n\t"
	"           st   %a0+,r18"         "\n\t"
	"           st   %a0+,r18"         "\n\t"
	"           st   %a0+,r18"         "\n\t"
	"           ldi r18,0x01"          "\n\t"   //'0x01'
	"           st   %a0,r18"          "\n\t"
	
	"EndFuncRes1: nop"                  "\n\t"
	:
	:"z"(res_lan)
	:"r16","r17","r18","r19"
	);

}

void Conver2 (void) //     2
{
 asm volatile
	(
	
	"           clt"                   "\n\t"
	"           rcall ResetLan2" 	   "\n\t"
	"           brts fn12"              "\n\t"
	"           ldi r18,0xcc"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"           ldi r18,0x4e"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"           ldi r18,0x7d"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"           ldi r18,0x77"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"           ldi r18,0x7f"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"           rcall ResetLan2" 	   "\n\t"
	"           brts fn12"             "\n\t"
	"           ldi r18,0xcc"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"           ldi r18,0x44"          "\n\t"
	"           rcall WriteByte2"      "\n\t"
	"fn12:      rjmp EndFuncCon2" 	   "\n\t"
	
	"ResetLan2: sbi %a3,%a1 "    	   "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"	       "\n\t"   //PORT_IO,DIO
	"           ldi  r16,230"          "\n\t"   //700uS
	"           rcall Del2"             "\n\t"
	"           cbi %a3,%a1 "    	   "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"	       "\n\t"   //PORT_IO,DIO
	"           ldi  r16,10"           "\n\t"
	"           rcall Del2"             "\n\t"
	"           sbic %a2,%a1"          "\n\t"
	"           set"                   "\n\t"
    "           ldi  r16,160"          "\n\t"   //500uS
	"           rcall Del2"             "\n\t"
	"           sbis %a2,%a1"          "\n\t"
	"           set"                   "\n\t"
	"           ret"                   "\n\t"
	
	"ReadSlot2:  sbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           nop"                   "\n\t"   //2uS
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
    "           cbi %a3,%a1 " 	       "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           ldi  r16,3"            "\n\t"   //13uS
	"           rcall Del2"             "\n\t"
	"           clc"                   "\n\t"
	"           sbic %a2,%a1"          "\n\t"   //PIN_IO,DIO
	"           sec"            	   "\n\t"
	"           ldi  r16,20"   	       "\n\t"   //60uS
	"           rcall Del2"      	   "\n\t"
	"           ret"            	   "\n\t"
	
	"WriteLow2:  sbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           ldi  r16,25"           "\n\t"   //80uS
	"           rcall Del2"             "\n\t"
	"           cbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"  	       "\n\t"   //PORT_IO,DIO
	"           ret"                   "\n\t"
	
	"WriteHigh2: sbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           cbi %a0,%a1"           "\n\t"   //PORT_IO,DIO
	"           nop"                   "\n\t"   //2uS
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           nop"                   "\n\t"
	"           cbi %a3,%a1"           "\n\t"   //DDR_IO,DIO
	"           sbi %a0,%a1"  	       "\n\t"   //PORT_IO,DIO
	"           ldi  r16,23"    	   "\n\t"   //75uS
	"           rcall Del2"      	   "\n\t"
	"           ret"           	       "\n\t"
	
	"ReadByte2:  ldi r17,8"     	       "\n\t"
	"           in __tmp_reg__,__SREG__""\n\t"
	"           clr r18"               "\n\t"
	"           cli"                   "\n\t"
	"rb12:       rcall ReadSlot2"        "\n\t"
	"           ror r18"               "\n\t"
	"           dec r17"               "\n\t"
	"           brne rb12"              "\n\t"
	"           out __SREG__,__tmp_reg__""\n\t"
	"           ret"                   "\n\t"
	
	"WriteByte2: ldi r17,8"             "\n\t"
	"           in __tmp_reg__,__SREG__""\n\t"
	"           cli"                   "\n\t"
	"wb12:       ror r18"               "\n\t"
	"           brcc wb22"              "\n\t"
	"           rcall WriteHigh2"       "\n\t"
	"           rjmp wb32"              "\n\t"
	"wb22:       rcall WriteLow2"        "\n\t"
	"wb32:       dec r17"               "\n\t"
	"           brne wb12"  			   "\n\t"
	"           out __SREG__,__tmp_reg__""\n\t"
	"           ret"           		   "\n\t"
	
	"Del2:       push r16"              "\n\t"
	"dl12:       dec r16"               "\n\t"
	"           brne dl12"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl22:       dec r16"               "\n\t"
	"           brne dl22"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl32:       dec r16"               "\n\t"
	"           brne dl32"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl42:       dec r16"               "\n\t"
	"           brne dl42"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl52:       dec r16"               "\n\t"
	"           brne dl52"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl62:       dec r16"               "\n\t"
	"           brne dl62"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl72:       dec r16"               "\n\t"
	"           brne dl72"              "\n\t"
	"           pop r16"               "\n\t"
	"           push r16"              "\n\t"
	"dl82:       dec r16"               "\n\t"
	"           brne dl82"              "\n\t"
	"           pop r16"               "\n\t"
	"           ret"                   "\n\t"
	
	"EndFuncCon2: nop"                   "\n\t"
	
	:
	:"I" (0x18),
     "I" (1),
     "I" (0x16),
     "I" (0x17)
	:"r16","r17","r18","r19"
	);
}


void Result2 (void *res_lan) //    2
{
 asm volatile
	(
	
	"           rcall ResetLan2" 	   "\n\t"
	"           brts Error2"            "\n\t"
	"           ldi r18,0xcc"          "\n\t"
	"           rcall WriteByte2"       "\n\t"
	"           ldi r18,0xbe"          "\n\t"
	"           rcall WriteByte2"       "\n\t"
	"           rcall ReadByte2"        "\n\t"
    "           mov r19,r18"           "\n\t"
	"           rcall ReadByte2"        "\n\t"
    "           adiw r30,4"            "\n\t"
	"           clr  r16"              "\n\t"
	"           st  %a0,r16"           "\n\t"
	"           tst r18 "              "\n\t"
	"           brpl rs12"              "\n\t"
	"           com r19"               "\n\t"
	"           subi r19,1"             "\n\t"
	"           com r18"               "\n\t"
	"           sbci r18,0"             "\n\t"
	"           ser  r16"              "\n\t"
	"           st   %a0,r16"          "\n\t"
	"rs12:      ldi  r16,0x07"         "\n\t"
	"           and  r18,r16"          "\n\t"
	"           ldi  r16,0x0f"         "\n\t"
	"           swap r18"              "\n\t"
	"           mov  r17,r19"          "\n\t"
	"           swap r19"              "\n\t"
	"           and  r19,r16"          "\n\t"
    "           and  r17,r16"          "\n\t"
	"           or   r18,r19"          "\n\t"
    "           ldi  r19,10"           "\n\t"
    "           mul  r17,r19"          "\n\t"
	"           swap __tmp_reg__"      "\n\t"
	"           and  r16,__tmp_reg__"  "\n\t"
	"           subi r16,0"            "\n\t" // -0,0C
	"           st   -%a0,r16"         "\n\t"
	"           eor __zero_reg__,__zero_reg__" "\n\t"
	"rs22:       subi r18,10 "          "\n\t"
	"           inc  __zero_reg__"     "\n\t"
	"           brcc rs22"              "\n\t"
	"           dec  __zero_reg__"     "\n\t"
	"           subi r18,0xf6"         "\n\t"
	"           st   -%a0,r18"         "\n\t"
	"           mov  r18,__zero_reg__" "\n\t"
	"           eor __tmp_reg__,__tmp_reg__" "\n\t"
	"rs32:       subi r18,10 "          "\n\t"
	"           inc  __tmp_reg__"      "\n\t"
	"           brcc rs32"              "\n\t"
	"           dec  __tmp_reg__"      "\n\t"
	"           subi r18,0xf6"         "\n\t"
    "           st   -%a0,r18"         "\n\t"
	"           st   -%a0,__tmp_reg__" "\n\t"
	"           rjmp EndFuncRes2"       "\n\t"

	"Error2:     clt"                   "\n\t"
	"           ldi r18,0x0f"          "\n\t"   //'?'
	"           st   %a0+,r18"         "\n\t"
	"           st   %a0+,r18"         "\n\t"
	"           st   %a0+,r18"         "\n\t"
	"           st   %a0+,r18"         "\n\t"
	"           ldi r18,0x01"          "\n\t"   //'0x01'
	"           st   %a0,r18"          "\n\t"
	
	"EndFuncRes2: nop"                  "\n\t"
	:
	:"z"(res_lan)
	:"r16","r17","r18","r19"
	);
}

void picterTEMP1 (void)
{  
 if (temp1[0]!=0)
 {
  ind[0] = 0x0B;       // Err
  ind[1] = 0x0B;
  ind[2] = 0x0A; 
  status &= ~_BV(comma);
 }
 else
 {   
  ind[0] = buftemp1[0];
  ind[1] = buftemp1[1];
  if(buftemp1[2]==0) ind[2] = 0x11;
  else ind[2] = buftemp1[2];
  status |= _BV(comma);
 }
}

void picterTEMP2 (void)
{  
 if (temp2[0]!=0)
 {
  ind[0] = 0x0B;       // Err
  ind[1] = 0x0B;
  ind[2] = 0x0A; 
  status &= ~_BV(comma);
 }
 else
 {     
  ind[0] = buftemp2[0];
  ind[1] = buftemp2[1];
  if(buftemp2[2]==0) ind[2] = 0x11;
  else ind[2] = buftemp2[2];
  status |= _BV(comma);
 }
}


void picterUST1 (void)
{     
  ind[0] = ust1[3];
  ind[1] = ust1[2];
  if(ust1[1]==0) ind[2] = 0x11;
  else ind[2] = ust1[1];
  status |= _BV(comma);
}

void picterUST2 (void)
{     
  ind[0] = ust2[3];
  ind[1] = ust2[2];
  if(ust2[1]==0) ind[2] = 0x11;
  else ind[2] = ust2[1];
  status |= _BV(comma);
}

void picterDLT1 (void)
{     
  ind[0] = dlt1[1];
  ind[1] = dlt1[0];
  ind[2] = 0x11;  
  status |= _BV(comma);
}


void picterDLT2 (void)
{     
  ind[0] = dlt2[1];
  ind[1] = dlt2[0];
  ind[2] = 0x11;  
  status |= _BV(comma);
}


void picterCOR1 (void)
{     
  ind[0] = cor1[2];
  ind[1] = cor1[1];
  if(cor1[0]==0) ind[2] = 0x11;      //SPASE
  else ind[2] = 0x12;
  status |= _BV(comma);
}


void picterCOR2 (void)
{     
  ind[0] = cor2[2];
  ind[1] = cor2[1];
  if(cor2[0]==0) ind[2] = 0x11;      //SPASE
  else ind[2] = 0x12;
  status |= _BV(comma);
}


void picterIND_US1 (void)
{     
  ind[0] = 0x01;        //ut1
  ind[1] = 0x10;
  ind[2] = 0x0E;      
  status &= ~_BV(comma);
}

void picterIND_US2 (void)
{     
  ind[0] = 0x02;        //ut2
  ind[1] = 0x10;
  ind[2] = 0x0E;      
  status &= ~_BV(comma);
}


void picterIND_DT1 (void)
{     
  ind[0] = 0x01;        //dt1
  ind[1] = 0x10;
  ind[2] = 0x0D;      
  status &= ~_BV(comma);
}


void picterIND_DT2 (void)
{     
  ind[0] = 0x02;        //dt2
  ind[1] = 0x10;
  ind[2] = 0x0D;      
  status &= ~_BV(comma);
}

void picterIND_CO1 (void)
{     
  ind[0] = 0x01;        //co1
  ind[1] = 0x0C; 
  ind[2] = 0x0F;      
  status &= ~_BV(comma);
}

void picterIND_CO2 (void)
{     
  ind[0] = 0x02;        //co2
  ind[1] = 0x0C;
  ind[2] = 0x0F;      
  status &= ~_BV(comma);
}
unsigned char BtnTest (void)
{
 unsigned char temp,cnt = 0;
 temp = klav;
 for(unsigned char i=0;i<8;i++)
 {
  if(bit_is_set(temp,7)) cnt++;
  temp = temp << 1;
 }
 return cnt;
}


void InitMcpu (void)
{
 eeprom_read_block(ust1,_ust1,5);
 eeprom_read_block(ust2,_ust2,5);
 eeprom_read_block(dlt1,_dlt1,2);
 eeprom_read_block(dlt2,_dlt2,2);
 eeprom_read_block(cor1,_cor1,3);
 eeprom_read_block(cor2,_cor2,3);
 OSCCAL = eeprom_read_byte(&_osccal);
 status = eeprom_read_byte(&_status);
 PORTD = 0xFF;
 PORTC = 0;
 DDRC = _BV(K0)|_BV(K1)|_BV(K2);
 DDRB = _BV(GR1)|_BV(GR2)|_BV(RD1)|_BV(RD2)|_BV(OUT1)|_BV(OUT2);
 DDRD = 0xFF;
 TCCR1B = _BV(CS11)|_BV(CS10)|_BV(WGM12);
 OCR1A = 0x1869;    //50mS
 TCCR0 = _BV(CS02);// F_CPU/256
 TIMSK = _BV(OCIE1A)|_BV(TOIE0);
 wdt_enable(WDTO_120MS);
}

int main (void)
{ 
 InitMcpu();
 ResetLed1();ResetLed2();
 sei();
 for(unsigned char i=0;i<8;i++)
  for(unsigned char j=0;j<8;j++) 
  {
   ind[0]=ind[2]=j+19;
   ind[1]=19+7-j;
   _delay_loop_2(50000);
   _delay_loop_2(50000);
   _delay_loop_2(50000);
  }
 klav = 0; status |= _BV(comma);
 for(;;)
 { 
 if(picter == TEMP1)
 {
  if(bit_is_set(klav,UP1))   {picter = TEMP2;status &= ~_BV(change);}
  if(bit_is_set(klav,DN1))   {status ^= _BV(termost1);
                              eeprom_write_byte(&_status,status&(_BV(termost1)|_BV(termost2)));} 
  if(bit_is_set(klav,MODE1)) status ^= _BV(change);
  if(bit_is_set(klav,MODE2)) {picter = IND_US1;status |= _BV(mode);status &= ~_BV(change);}
  klav = 0;
 }
 
 if(picter == TEMP2)
 {
  if(bit_is_set(klav,DN1))   {picter = TEMP1;status &= ~_BV(change);}
  if(bit_is_set(klav,UP1))   {status ^= _BV(termost2);
                              eeprom_write_byte(&_status,status&(_BV(termost1)|_BV(termost2)));}  
  if(bit_is_set(klav,MODE1)) status ^= _BV(change);
  if(bit_is_set(klav,MODE2)) {picter = IND_US2;status |= _BV(mode);status &= ~_BV(change);}
  klav = 0;
 } 
 
 if(picter == IND_US1)
 {
  if(bit_is_set(klav,UP1))   picter = IND_DT1;
  if(bit_is_set(klav,DN1))   picter = IND_CO1;
  if(bit_is_set(klav,MODE1)) picter = UST1;
  klav =0;
 }
 
 if(picter == IND_US2)
 {
  if(bit_is_set(klav,UP1))   picter = IND_DT2;
  if(bit_is_set(klav,DN1))   picter = IND_CO2;
  if(bit_is_set(klav,MODE1)) picter = UST2;
  klav =0;
 }
 
 if(picter == IND_DT1)
 {
  if(bit_is_set(klav,UP1))   picter = IND_CO1;
  if(bit_is_set(klav,DN1))   picter = IND_US1;
  if(bit_is_set(klav,MODE1)) picter = DLT1;
  klav =0;
 }
 
 if(picter == IND_DT2)
 {
  if(bit_is_set(klav,UP1))   picter = IND_CO2;
  if(bit_is_set(klav,DN1))   picter = IND_US2;
  if(bit_is_set(klav,MODE1)) picter = DLT2;
  klav =0;
 }
 
 if(picter == IND_CO1)
 {
  if(bit_is_set(klav,UP1))   picter = IND_US1;
  if(bit_is_set(klav,DN1))   picter = IND_DT1;
  if(bit_is_set(klav,MODE1)) picter = COR1;
  klav =0;
 }
 
 if(picter == IND_CO2)
 {
  if(bit_is_set(klav,UP1))   picter = IND_US2;
  if(bit_is_set(klav,DN1))   picter = IND_DT2;
  if(bit_is_set(klav,MODE1)) picter = COR2;
  klav =0;
 }
 
 if(picter == UST1)
 {
  if(bit_is_set(klav,UP1)||bit_is_set(klav,UP2))
  {
   temprary = 100*ust1[1] + 10*ust1[2] + ust1[3];
   if(temprary!=950) temprary++;
   ust1[3] = temprary%10;
   ust1[2] = (temprary/10)%10;
   ust1[1] = temprary/100;
  }
  if(bit_is_set(klav,DN1)||bit_is_set(klav,DN2))
  {
   temprary = 100*ust1[1] + 10*ust1[2] + ust1[3];
   if(temprary!=50) temprary--;
   ust1[3] = temprary%10;
   ust1[2] = (temprary/10)%10;
   ust1[1] = temprary/100;
  }
  if(bit_is_set(klav,MODE1))
  { 
   picter = IND_US1;
   eeprom_write_block(ust1,_ust1,sizeof(ust1));
  }
   klav =0;
 }
  
 if(picter == UST2)
 {
  if(bit_is_set(klav,UP1)||bit_is_set(klav,UP2))
  {
   temprary = 100*ust2[1] + 10*ust2[2] + ust2[3];
   if(temprary!=950) temprary++;
   ust2[3] = temprary%10;
   ust2[2] = (temprary/10)%10;
   ust2[1] = temprary/100;
  }
  if(bit_is_set(klav,DN1)||bit_is_set(klav,DN2))
  {
   temprary = 100*ust2[1] + 10*ust2[2] + ust2[3];
   if(temprary!=50) temprary--;
   ust2[3] = temprary%10;
   ust2[2] = (temprary/10)%10;
   ust2[1] = temprary/100;
  }
  if(bit_is_set(klav,MODE1))
  { 
   picter = IND_US2;
   eeprom_write_block(ust2,_ust2,sizeof(ust2));
  }
  klav =0;
 } 
  
 if(picter == DLT1)
 {
  if(bit_is_set(klav,UP1)||bit_is_set(klav,UP2))
  {
   temprary = 10*dlt1[0] + dlt1[1];
   if(temprary!=40) temprary++;
   dlt1[1] = temprary%10;
   dlt1[0] = temprary/10;
  }
  if(bit_is_set(klav,DN1)||bit_is_set(klav,DN2))
  {
   temprary = 10*dlt1[0] + dlt1[1];
   if(temprary!=0) temprary--;
   dlt1[1] = temprary%10;
   dlt1[0] = temprary/10;
  }
  if(bit_is_set(klav,MODE1))
  { 
   picter = IND_DT1;
   eeprom_write_block(dlt1,_dlt1,sizeof(dlt1));
  }
  klav =0;
 }
 
 if(picter == DLT2)
 {
  if(bit_is_set(klav,UP1)||bit_is_set(klav,UP2))
  {
   temprary = 10*dlt2[0] + dlt2[1];
   if(temprary!=40) temprary++;
   dlt2[1] = temprary%10;
   dlt2[0] = temprary/10;
  }
  if(bit_is_set(klav,DN1)||bit_is_set(klav,DN2))
  {
   temprary = 10*dlt2[0] + dlt2[1];
   if(temprary!=0) temprary--;
   dlt2[1] = temprary%10;
   dlt2[0] = temprary/10;
  }
  if(bit_is_set(klav,MODE1))
  { 
   picter = IND_DT2;
   eeprom_write_block(dlt2,_dlt2,sizeof(dlt2));
  }
  klav =0;
 }
 
 if(picter == COR1)
 {
  if(bit_is_set(klav,UP1)||bit_is_set(klav,UP2))
  {
   temprary = 10*cor1[1] + cor1[2];
   if(cor1[0]!=0) temprary = (0xFFFF-temprary)+1;
   if(temprary!=20) temprary++;
   if(temprary<0) {cor1[0] = 0xFF;temprary = (0xFFFF-temprary)+1;}
   else cor1[0] =0;
   cor1[2] = temprary%10;
   cor1[1] = temprary/10;
  }
  if(bit_is_set(klav,DN1)||bit_is_set(klav,DN2))
  {
   temprary = 10*cor1[1] + cor1[2];
   if(cor1[0]!=0) temprary = (0xFFFF-temprary)+1;
   if(temprary!=(-20)) temprary--;
   if(temprary<0) {cor1[0] = 0xFF;temprary = (0xFFFF-temprary)+1;}
   else cor1[0] =0;
   cor1[2] = temprary%10;
   cor1[1] = temprary/10;
  }
  if(bit_is_set(klav,MODE1))
  { 
   picter = IND_CO1;
   eeprom_write_block(cor1,_cor1,sizeof(cor1));
  }
  klav =0;
 }
 
 if(picter == COR2)
 {
  if(bit_is_set(klav,UP1)||bit_is_set(klav,UP2))
  {
   temprary = 10*cor2[1] + cor2[2];
   if(cor2[0]!=0) temprary = (0xFFFF-temprary)+1;
   if(temprary!=20) temprary++;
   if(temprary<0) {cor2[0] = 0xFF;temprary = (0xFFFF-temprary)+1;}
   else cor2[0] =0;
   cor2[2] = temprary%10;
   cor2[1] = temprary/10;
  }
  if(bit_is_set(klav,DN1)||bit_is_set(klav,DN2))
  {
   temprary = 10*cor2[1] + cor2[2];
   if(cor2[0]!=0) temprary = (0xFFFF-temprary)+1;
   if(temprary!=(-20)) temprary--;
   if(temprary<0) {cor2[0] = 0xFF;temprary = (0xFFFF-temprary)+1;}
   else cor2[0] =0;
   cor2[2] = temprary%10;
   cor2[1] = temprary/10;
  }
  if(bit_is_set(klav,MODE1))
  { 
   picter = IND_CO2;
   eeprom_write_block(cor2,_cor2,sizeof(cor2));
  }
  klav =0;
 }
  

 switch(picter)
 {
  case TEMP1:picterTEMP1();break;
  case TEMP2:picterTEMP2();break;
  case UST1:picterUST1();break;
  case UST2:picterUST2();break;
  case DLT1:picterDLT1();break;
  case DLT2:picterDLT2();break;
  case COR1:picterCOR1();break;
  case COR2:picterCOR2();break;
  case IND_US1:picterIND_US1();break;
  case IND_US2:picterIND_US2();break;
  case IND_DT1:picterIND_DT1();break;
  case IND_DT2:picterIND_DT2();break;
  case IND_CO1:picterIND_CO1();break;
  case IND_CO2:picterIND_CO2();break;
 }
 
 if(bit_is_clear(status,mode))
 {  
  if(bit_is_set(status,termost1)&&(tempr1!=0)&&(temp1[4]==0))
  {
   if(bit_is_set(status,gist1))
   {
    if(tempr1<mintempr1) {PORTB |= _BV(OUT1);status &= ~_BV(gist1);}
    else PORTB &= ~_BV(OUT1);
   }
   else
   {
    if(tempr1<maxtempr1) PORTB |= _BV(OUT1);
    else {PORTB &= ~_BV(OUT1);status |= _BV(gist1);}
   }
  }
  else {PORTB &= ~_BV(OUT1);status &= ~_BV(gist1);}
 
  if(bit_is_set(status,termost2)&&(tempr2!=0)&&(temp2[4]==0))
  {
   if(bit_is_set(status,gist2))
   {
    if(tempr2<mintempr2) {PORTB |= _BV(OUT2);status &= ~_BV(gist2);}
    else PORTB &= ~_BV(OUT2);
   }
   else
   {
    if(tempr2<maxtempr2) PORTB |= _BV(OUT2);
    else {PORTB &= ~_BV(OUT2);status |= _BV(gist2);}
   }
  }
  else {PORTB &= ~_BV(OUT2);status &= ~_BV(gist2);}
 
  }
  else PORTB &= ~(_BV(OUT1)|_BV(OUT2));
  
 switch(picter)
 {
  case UST1:case DLT1:case COR1:case IND_US1:case IND_DT1:case IND_CO1:
       ResetLed2();SetYellow1();break;
  case UST2:case DLT2:case COR2:case IND_US2:case IND_DT2:case IND_CO2:
       ResetLed1();SetYellow2();break;	   
  case TEMP1:if(bit_is_set(status,termost1))
			  if(bit_is_set(PORTB,OUT1)) {SetRed1();}
			  else {SetGreen1();}
             else {SetYellow1();}
			 ResetLed2();break;		 
  case TEMP2:if(bit_is_set(status,termost2))
			  if(bit_is_set(PORTB,OUT2)) {SetRed2();}
			  else {SetGreen2();}
             else {SetYellow2();}
			 ResetLed1();break; 
 }
  
 }
}


SIGNAL(SIG_OVERFLOW0)
{
 TCNT0 = 0x83;
 snkcnt++;
 if(snkcnt==200)
 {
  snkcnt = 0;
  if(concnt==3) concnt=0;
   else concnt++;
  if(bit_is_set(status,mode)) {concnt=0; status &= ~_BV(qwsec);}
   else status |= _BV(qwsec);
 } 
 if(dgcnt==2) dgcnt=0;
 else dgcnt++;
 if((dgcnt==1)&&(bit_is_set(status,comma))) PORTD = encod[ind[dgcnt]]&0x7F;
 else PORTD = encod[ind[dgcnt]];
 PORTC &= ~(_BV(K0)|_BV(K1)|_BV(K2));
 switch(dgcnt)
 {
  case 0:PORTC |= _BV(K0);break; 
  case 1:PORTC |= _BV(K1);break;
  case 2:PORTC |= _BV(K2);break; 
 }
 if(bit_is_set(status,qwsec)) 
  {
   status ^= _BV(qwsec);
   sei();
   switch(concnt)
   {
    case 0:Conver1();break; 
    case 1:Conver2();break;
    case 2:Result1(temp1);break; 
    case 3:Result2(temp2);break;
   }
  }
  
   if(temp1[0]==0)
   {
   temprary = 100*temp1[1] + 10*temp1[2] + temp1[3];
   if(cor1[0]!=0) temprary -= 10*cor1[1] + cor1[2];
   else temprary += 10*cor1[1] + cor1[2];
   buftemp1[0] = temprary%10;
   buftemp1[1] = (temprary/10)%10;
   buftemp1[2] = temprary/100;
   tempr1 = temprary;
   }
   else tempr1=0;
   
   if(temp2[0]==0)
   {
   temprary = 100*temp2[1] + 10*temp2[2] + temp2[3];
   if(cor2[0]!=0) temprary -= 10*cor2[1] + cor2[2];
   else temprary += 10*cor2[1] + cor2[2];
   buftemp2[0] = temprary%10;
   buftemp2[1] = (temprary/10)%10;
   buftemp2[2] = temprary/100;
   tempr2 = temprary;
   }
   else tempr2=0;
     
   maxtempr1 = 100*ust1[1] + 10*ust1[2] + ust1[3];
   mintempr1 = maxtempr1 - 10*dlt1[0] - dlt1[1];
   
   maxtempr2 = 100*ust2[1] + 10*ust2[2] + ust2[3];
   mintempr2 = maxtempr2 - 10*dlt2[0] - dlt2[1];
}

SIGNAL(SIG_OUTPUT_COMPARE1A) 
{  
   wdt_reset();
   if(bit_is_set(status,mode))
   { 
    modcnt++;
	if(modcnt==100)
	{
	 status &= ~_BV(mode);modcnt=0;
     switch(picter)
     {
      case UST1:picter = TEMP1;eeprom_write_block(ust1,_ust1,sizeof(ust1));break;
      case UST2:picter = TEMP2;eeprom_write_block(ust2,_ust2,sizeof(ust2));break;
      case DLT1:picter = TEMP1;eeprom_write_block(dlt1,_dlt1,sizeof(dlt1));break;
      case DLT2:picter = TEMP2;eeprom_write_block(dlt2,_dlt2,sizeof(dlt2));break;
      case COR1:picter = TEMP1;eeprom_write_block(cor1,_cor1,sizeof(cor1));break;
      case COR2:picter = TEMP2;eeprom_write_block(cor2,_cor2,sizeof(cor2));break;
	  case IND_US1:case IND_DT1:case IND_CO1:picter = TEMP1;break;
	  case IND_US2:case IND_DT2:case IND_CO2:picter = TEMP2;break;
      default:break;
     }
	}
   }
   
   if(bit_is_set(status,change))
   {
    chncnt++;
	if(chncnt==100)
	{
	 if(picter==TEMP1) picter = TEMP2;
	 else picter = TEMP1;
	 chncnt=0;
	}
   } 
   else chncnt=0;
	
   if(bit_is_clear(PINC,UP))
   switch (cntUP)
   {
    case 0:klav |= _BV(UP1);cntUP++;break;
    case 40:klav |= _BV(UP2);break;
	default:cntUP++;break;
   }
   else cntUP =0;
   
   if(bit_is_clear(PINC,DN))
   switch (cntDN)
   {
    case 0:klav |= _BV(DN1);cntDN++;break;
    case 40:klav |= _BV(DN2);break;
	default:cntDN++;break;
   }
   else cntDN =0;
   
   if(bit_is_clear(PINC,MODE))
   switch (cntMODE)
   {
    case 0:klav |= _BV(MODE1);cntMODE++;break;
    case 40:klav |= _BV(MODE2);break;
	default:cntMODE++;break;
   }
   else cntMODE =0;
   if(BtnTest()==1) modcnt = 0;
   else klav=0;
}








