#include <WProgram.h>
#include <NECIRrcv.h>
#include <avr/interrupt.h >
#include <avr/io.h >

#define INIT_TIMER_COUNT 6
#define RESET_TIMER2 TCNT2 = INIT_TIMER_COUNT

#define BK_TV 4228082566 // TV/FM
#define BK_SC 4161235846 // SCAN
#define BK_ZO 3810290566 // ZOOM
#define BK_P 3776867206 // POWER
#define BK_1 4261505926 // 1
#define BK_2 4094389126 // 2
#define BK_3 3827002246 // 3
#define BK_4 4194659206 // 4
#define BK_5 4127812486 // 5
#define BK_6 3927272326 // 6
#define BK_7 4177947526 // 7
#define BK_8 4111100806 // 8
#define BK_9 3977407366 // 9
#define BK_0 4244794246 // 0
#define BK_VP 3760155526 // VOLUME +
#define BK_VM 3893848966 // VOLUME -
#define BK_CP 3910560646 // CHANNEL +
#define BK_CM 3943984006 // CHANNEL -
#define BK_MU 3877137286 // MUTE
#define BK_10 4010830726 // +100
#define BK_LO 3960695686 // LOOP
#define BK_SO 4278217606 // SOURCE
#define BK_MI 4211370886 // -
#define BK_FU 4044254086// FUNCTION
#define BK_PL 4077677446 // +
#define BK_RS 4060965766 // RESET
#define BK_FR 4027542406 // FREEZY

int state = 0;
int led_state = 0;
int set_leds = 0;
unsigned long dead_time = 0;
unsigned long ircode ;
unsigned long time = 0;
int ttime = 0;
int pLed = 10;
int leftReed = 7;
int rightReed = 8;
int motor1 = 4;
int motor2 = 2;
int statLed = 10;
int led1 = 11;
int led2 = 12;






NECIRrcv ir(6);



void setLeds(int leds){
  if(bitRead(leds,0) == 1){
    digitalWrite(led1, HIGH);
  }
  else{
    digitalWrite(led1, LOW);
  }
  if(bitRead(leds,1) == 1){
    digitalWrite(led2, HIGH);
  }
  else{
    digitalWrite(led2, LOW);
  }
}

void seet(int leds,int mode){
  if(bitRead(leds,0) == 1){
    digitalWrite(led1, mode);
    digitalWrite(led2, LOW);
  }
  if(bitRead(leds,1) == 1){
    digitalWrite(led2, mode);
    digitalWrite(led1, LOW);
  }
}

void setup(){
  pinMode(leftReed, INPUT);
  pinMode(rightReed, INPUT);
  pinMode(motor1, OUTPUT);
  pinMode(motor2, OUTPUT);
  pinMode(pLed, OUTPUT);
  
  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);
  digitalWrite(pLed, HIGH);
  Serial.begin(9600) ;
  Serial.println("NEC IR code reception") ;
  ir.begin() ;
}

void loop(){

  if(ir.available()){
    ircode = ir.read();
    Serial.println(ircode, DEC) ;
    switch(state){
    case 0:
      switch(long(ircode)){
        case BK_MI:
          rotateLeft(0);
          state = 1;
        break;
        case BK_PL:
          rotateRight(0);
          state = 1;
        break;
        case BK_RS:
          rotateLeft(200);
        break;
        case BK_FR:
          rotateRight(200);
        break;
        case BK_FU:
          state = 1;
          break;
        case BK_SC:
          state = 2;
          //RESET_TIMER2;
          time = dead_time = millis();
          set_leds = 1;
        break;
      }
      break;

    case 2:
      switch(long(ircode)){
      case BK_SC:
        state = 2;
        //RESET_TIMER2;
        time = dead_time = millis();
        set_leds++; 
        if(set_leds == 3) state = 1;
        break;

      case BK_FU:
        state = 3;
        //RESET_TIMER2;
        time = dead_time = millis();
        break;
      }
      break;
    }
  }
  switch(state){
  case 1:
    digitalWrite(pLed, HIGH);
    if(long(ircode) == BK_FU){
      led_state++;
      if(led_state == 4) led_state = 0;
    }
    Serial.println(led_state, DEC);
    setLeds(led_state);
    state = 0;
    break;
  case 2:
    if( millis()-time > 500 ){
      if(millis()-time > 1000) time = millis();
      seet(set_leds, LOW);
    }
    else{
      seet(set_leds, HIGH);
    }
    if(millis()-dead_time > 20000) {
      state = 1;
    }
    break;    

  case 3:
    if( millis()-time > 200 ){
      if(millis()-time > 400) time = millis();
      seet(set_leds, LOW);
    }
    else{
      seet(set_leds, HIGH);
    }
    if(millis()-dead_time > 5000) {
      state = 1;
      seet(set_leds, HIGH);
      delay(1000);
    }
    break;
  }
  ircode = 0;
}

void rotateLeft(int time){
  ttime = millis();
  if(time > 0){
    while(millis() - ttime < time && digitalRead(leftReed) == LOW){
      digitalWrite(motor1, HIGH);
      digitalWrite(motor2, LOW);
    }
  }else{
    while( digitalRead(leftReed) == LOW ){
      blinkleds(200);
      digitalWrite(motor1, HIGH);
      digitalWrite(motor2, LOW);
    }
  }
  stop();
  
}

void rotateRight(int time){
  ttime = millis();
  if(time > 0){
    while(millis() - ttime < time && digitalRead(rightReed) == LOW){
      digitalWrite(motor1, LOW);
      digitalWrite(motor2, HIGH);
    }
  }else{
    while( digitalRead(rightReed) == LOW ){
      blinkleds(200);
      digitalWrite(motor1, LOW);
      digitalWrite(motor2, HIGH
      );
    }
  }
  stop();
  
}

void blinkleds(int blinktime){
  if( millis()-ttime > blinktime ){
      if(millis()-ttime > blinktime) ttime = millis();
      digitalWrite(pLed, LOW);
    }
    else{
      digitalWrite(pLed, HIGH);
    }
}

void stop(){
  digitalWrite(motor1, LOW);
  digitalWrite(motor2, LOW);
}
