.include "d:\avr\avrasm\appnotes\2313def.inc"


	.def	Temp1=R16
	.def	Temp2=R17
	.def	Temp3=R18
	.def	Temp4=R19
	.def	Temp=R20

.dseg

CountRate:	.byte 1
MelAddL:	.byte 1
MelAddH:	.byte 1

;******************************************************************************
.macro	stsi		;save_immediate <SRAM_cell>,<k>
	ldi Temp,@1
	sts @0,Temp
.endmacro

.macro	rdm
	ldi ZH,High(@0*2)
	ldi ZL,Low(@0*2)
	add ZL,XL
	adc ZH,XH
	lpm
	mov Temp3,r0
.endmacro
;******************************************************************************

.cseg
.org 0

              rjmp RESET    ; Reset Handler
	rjmp EXT_INT0 ; IRQ0 Handler
	rjmp EXT_INT1 ; IRQ1 Handler
	rjmp TIM_CAPT1 ; Timer1 Capture Handler
	rjmp TIM_COMP1 ; Timer1 Compare Handler
	rjmp TIM_OVF1 ; Timer1 Overflow Handler
	rjmp TIM_OVF0 ; Timer0 Overflow Handler
	rjmp UART_RXC ; UART RX Complete Handler
	rjmp UART_DRE ; UDR Empty Handler
	rjmp UART_TXC ; UART TX Complete Handler
	rjmp ANA_COMP ; Analog Comparator Handler



EXT_INT0  :	ret
EXT_INT1  :	ret
TIM_CAPT1 :	ret
TIM_OVF0  :	ret
TIM_OVF1  :   ret
UART_RXC  :   ret
UART_DRE  :   ret
UART_TXC  :   ret
ANA_COMP  :   ret
TIM_COMP1 :   ret



reset:	ldi Temp1,RamEnd	;set stack
	out SPL,Temp1

	cli
	inc Temp3



	ldi temp1,0xff	;port init
	out ddrb,temp1
	ldi temp1,0b00000001
	out portb,Temp1
                                          ;timers init
	ldi temp1,0b01000000	;OC1 toggle at compare
	out tccr1a,temp1
	ldi temp1,0b00001011
	out tccr1b,temp1    	;clear on compare, clk=C/64

	ldi Temp1,1
	sts CountRate,Temp1


;**********************************************************************************************
;Partiture reader

;input:
;output: Temp3 - code of current note

Partiture:    ldi XL,0
	ldi XH,0
	ldi Temp1,0
	ldi Temp2,0

Play:
	rdm HymnUSSR
	cpi Temp3,0xff	;comparing with "end" flag
	breq Partiture

	sts MelAddL,XL
	sts MelAddH,XH
	rcall Note

	lds XL,MelAddL
	lds XH,MelAddH
	adiw XL,1

	rdm HymnUSSR
	rcall Wait
	adiw XL,1

	rjmp Play




HymnUSSR:	.db 19,24,24,32		;
	.db 19,24,21,8,23,32		;
	.db 16,12,254,4,16,16,21,32		; 
	.db 19,24,17,8,19,32		; 
	.db 12,12,254,4,12,16,14,32		; 
	.db 14,16,16,16,17,32		; 
	.db 17,16,19,16,21,32		; 
	.db 23,24,24,8,26,16		; 
	.db 19,4,254,2,19,4,254,2,16,16,254,2	;--
	.db 19,16,28,32		; 
	.db 26,24,24,8,26,32		; 
	.db 23,16,19,16,24,32		; 
	.db 23,24,21,8,23,32		; 
	.db 19,16,16,16,21,32		; 
	.db 19,16,17,16,19,32		; 
	.db 14,16,12,16,24,32		; 
	.db 23,16,21,16,19,16		; 
	.db 19,4,254,2,19,4,254,2,21,16,23,16	;--
	.db 28,64,26,16,24,16,23,16,24,16,26,16	;--- ----
	.db 254,2,19,4,254,2,19,4,254,2,19,12	;-- 
	.db 254,4,18,12,254,4,19,12,254,4	; 
	.db 19,16,21,16,23,16		;-
	.db 24,64,23,16,21,16,19,16,21,16,23,16	;--- - --
	.db 254,2,16,4,254,2,16,4,254,2,16,12	;-- 
	.db 254,4,16,12,254,4,16,12,254,4	;-- 
	.db 16,16,17,16,19,16		;-
	.db 21,32,17,16,19,16,21,32		; 
	.db 17,24,19,8,21,32		; 
	.db 17,16,21,16,26,64		; 
	.db 29,64,28,16,26,16,24,16,26,16,28,48	;--- --- 
	.db 24,12,254,4,24,64		;---
	.db 26,64,24,16,23,16,21,16,23,16,24,48	;--- - --
	.db 21,12,254,4,21,16,19,16,21,16,23,16	;---
	.db 24,32,23,24,21,8,19,32		;  
	.db 14,8,254,8,12,16,24,32		;-
	.db 23,16,21,16,19,12,254,4,17,8,254,4,255,0	; !


;  (263) #(285) (297) #(316) (330) (351) #(375) (395) #(422)(440) #(474) (494)
;  0       1        2       3        4       5       6        7         8         9       10       11
;  12      13       14      15       16      17      18       19        20        21      22       23
;  24      25       26      27       28      29      30       31        32        33      34       35




;****************************************************

Note:	ldi ZH,High(Notelist*2)
	ldi ZL,Low(Notelist*2)


	ldi Temp1,0
	clc
	rol Temp3
	rol Temp1

	add ZL,Temp3
	adc ZH,Temp1

	lpm
	mov Temp2,r0
	adiw ZL,1

	lpm
	mov Temp1,r0
	rcall NotePlay
	ret


;	    (263)   #(285)  (297)   #(316)  (330)   (351)   #(375)  (395) #(422)(440)   #(474)  (494)
;	    0         1         2         3         4         5         6         7         8         9         10        11
Notelist:	.db 0x02,0x50,0x02,0x24,0x02,0x0e,0x01,0xed,0x01,0xd9,0x01,0xbc,0x01,0xa0,0x01,0x8b,0x01,0x72,0x01,0x63,0x01,0x49,0x01,0x3c;. 
;                 12        13        14        15        16        17        18        19        20        21        22        23
	.db 0x01,0x28,0x01,0x12,0x01,0x07,0x00,0xf6,0x00,0xec,0x00,0xde,0x00,0xd0,0x00,0xc5,0x00,0xb9,0x00,0xb1,0x00,0xa4,0x00,0x9e;. 
;	    24        25        26        27        28        29        30        31        32        33        34        35
	.db 0x00,0x94,0x00,0x89,0x00,0x83,0x00,0x7b,0x00,0x76,0x00,0x6f,0x00,0x68,0x00,0x62,0x00,0x5c,0x00,0x58,0x00,0x52,0x00,0x4f;1 





NotePlay:	ldi Temp3,0
	out tcnt1h,Temp3
	out tcnt1l,Temp3
	out ocr1ah,temp2
	out ocr1al,temp1
	ret

;************************************************************

Wait:	push Temp1
	push Temp2

	ldi Temp1,0
	ldi Temp2,0

l:	dec temp1
	brne l

	dec temp2
	brne l

	dec temp3
	brne l

	pop Temp2
	pop Temp1
	ret