.include "d:\avr\avrasm\appnotes\2313def.inc"


	.def	Temp1=R16
	.def	Temp2=R17
	.def	Temp3=R18
	.def	Temp4=R19
	.def	Temp=R20
	.def	DecCount=R21
	.def	Scd=R22
	.def	Min=R23
	.def	Hour=R24
	.def	Status=R25


.dseg

Line0:	.byte 1
Line1:	.byte 1
Line2:	.byte 1
Line3:	.byte 1
Line4:	.byte 1
Line5:	.byte 1
Line6:	.byte 1
Line7:	.byte 1
Line8:	.byte 1
Line9:	.byte 1
Line10:	.byte 1
Line11:	.byte 1
Line12:	.byte 1
Line13:	.byte 1

HourH:	.byte 1
HourL:	.byte 1
MinH:	.byte 1
MinL:	.byte 1

PWMcount:	.byte 1
Klava:	.byte 1


;******************************************************************************
.macro	stsi		;save_immediate <SRAM_cell>,<k>
	ldi Temp,@1
	sts @0,Temp
.endmacro

.macro	outi
	ldi Temp,@1
	out @0,Temp
.endmacro

.macro	rdm
	ldi ZH,High(@0*2)
	ldi ZL,Low(@0*2)
	add ZL,Temp1
	adc ZH,Temp2
	lpm
	mov Temp3,r0
.endmacro
;******************************************************************************

.cseg
.org 0

              rjmp RESET    ; Reset Handler
	rjmp EXT_INT0 ; IRQ0 Handler
	rjmp EXT_INT1 ; IRQ1 Handler
	rjmp TIM_CAPT1 ; Timer1 Capture Handler
	rjmp TIM_COMP1 ; Timer1 Compare Handler
	rjmp TIM_OVF1 ; Timer1 Overflow Handler
	rjmp TIM_OVF0 ; Timer0 Overflow Handler
	rjmp UART_RXC ; UART RX Complete Handler
	rjmp UART_DRE ; UDR Empty Handler
	rjmp UART_TXC ; UART TX Complete Handler
	rjmp ANA_COMP ; Analog Comparator Handler



EXT_INT0  :	ret
EXT_INT1  :	ret
TIM_CAPT1 :	ret
TIM_OVF0  :	ret
TIM_OVF1  :   ret
UART_RXC  :   ret
UART_DRE  :   ret
UART_TXC  :   ret
ANA_COMP  :   ret
;TIM_COMP1 :   ret



reset:	ldi Temp1,RamEnd	;set stack
	out SPL,Temp1

	cli

	ldi temp1,0xff	;port init
	out ddrb,temp1
	ldi temp1,0b01111100
	out ddrd,temp1

              outi TIMSK,0b01000000
	outi TCCR1A,0b00000000
	outi TCCR1B,0b00001010      ;TCNT1 prescaler = f/8

	wdr
;	outi WDTCR,0b00001100
	wdr


	ldi Temp1,0x30	;TCNT1 division koef.= 12500(10) = 30d4(2)
	ldi Temp2,0xD4

	out OCR1AH,Temp1
	out OCR1AL,Temp2

	ldi DecCount,0
	clr Temp
	clr Temp1
	clr Temp2
	clr Temp3
	clr Temp4

	stsi Line0,0
	stsi Line1,0
	stsi Line2,0
	stsi Line3,0
	stsi Line4,0
	stsi Line5,0
	stsi Line6,0
	stsi Line7,0
	stsi Line8,0
	stsi Line9,0
	stsi Line10,0
	stsi Line11,0
	stsi Line12,0
	stsi Line13,0

              sei

;********************************************************
Indicate:
;inputs: line0...line13
;outputs: data in PortB, PortD




	ldi Temp1,0b00000000
	rcall SendAdd
	lds Temp1,Line0
	rcall IndicDelay

	ldi Temp1,0b00000100
	rcall SendAdd
	lds Temp1,Line1
	rcall IndicDelay

	ldi Temp1,0b00001000
	rcall SendAdd
	lds Temp1,Line2
	rcall IndicDelay

	ldi Temp1,0b00001100
	rcall SendAdd
	lds Temp1,Line3
	rcall IndicDelay

	ldi Temp1,0b00010000
	rcall SendAdd
	lds Temp1,Line4
	rcall IndicDelay

	ldi Temp1,0b00010100
	rcall SendAdd
	lds Temp1,Line5
	rcall IndicDelay

	ldi Temp1,0b00011000
	rcall SendAdd
	lds Temp1,Line6
	rcall IndicDelay

	ldi Temp1,0b00011100
	rcall SendAdd
	lds Temp1,Line7
	rcall IndicDelay

	ldi Temp1,0b00100000
	rcall SendAdd
	lds Temp1,Line8
	rcall IndicDelay

	ldi Temp1,0b00100100
	rcall SendAdd
	lds Temp1,Line9
	rcall IndicDelay

	ldi Temp1,0b00101000
	rcall SendAdd
	lds Temp1,Line10
	rcall IndicDelay
	sbic PinD,0
	ori Status,0b00000001

	ldi Temp1,0b00101100
	rcall SendAdd
	lds Temp1,Line11
	sbrc Status,6
	ori Temp1,0b10000000
	rcall IndicDelay
	sbic PinD,0
	ori Status,0b00000010

	ldi Temp1,0b00110000
	rcall SendAdd
	lds Temp1,Line12
	rcall IndicDelay
	sbic PinD,0
	ori Status,0b00000100

	ldi Temp1,0b00110100
	rcall SendAdd
	lds Temp1,Line13
	rcall IndicDelay
	sbic PinD,0
	ori Status,0b00001000




StatusTest:
ST1:	sbrs Status,7		;testing for secund increment
	rjmp ST2
	andi Status,0b01111111
	rcall Secund
	mov Temp1,Min
	rcall LineDecoder1
	mov Temp1,Scd
	rcall LineDecoder2
	mov Temp1,Hour
	rcall LineDecoder3

	rcall SegmentOut

ST2:	mov Temp1,Status		;testing for any button pressed
	andi Status,0b11110000
	andi Temp1,0b00001111

	lds Temp2,Klava
	cp Temp2,Temp1
	breq EndIndicate
	sts Klava,Temp1
	rcall Buttons


EndIndicate:
ErrorCorrect:
Det1:	cpi Scd,60
	brmi Det2
	clr Scd

Det2:	cpi Min,60
	brmi Det3
	clr Min

Det3:	cpi Hour,24
	brmi Det4
	clr Hour

Det4:	cpi DecCount,10
	brmi Det5
	clr DecCount

Det5:	mov Temp1,Status
	andi Temp1,0b10111111
	cpi Temp1,0b01000000
	brmi Det6
	clr Status

Det6:

	rjmp Indicate


;**************************************************
IndicDelay:	ldi temp2,0xff
              eor Temp1,Temp2
	out PortB,Temp1

	ldi Temp1,0
	ldi Temp2,2

l1:	dec Temp1
	brne l1

	dec Temp2
	brne l1

	ret

;**************************************************
;**************************************************
Buttons:
;button click process

	sbrc Temp1,0
	rjmp But0
	sbrc Temp1,1
	rjmp But1
	sbrc Temp1,2
	rjmp But2
	sbrc Temp1,3
	rjmp But3
	rjmp EndBut

But0: 	rcall HourInc
	mov Temp1,Hour
	rcall LineDecoder3
	rcall SegmentOut
	rjmp EndBut

But1:	rcall MinInc
	mov Temp1,Min
	rcall LineDecoder1
	rcall SegmentOut
	rjmp EndBut

But2:	inc Scd
	mov Temp1,Min
	rcall LineDecoder1
	mov Temp1,Scd
	rcall LineDecoder2
	rjmp EndBut

But3:         clr Scd
	clr Temp1
              rcall TimReset
	rcall LineDecoder2
	rjmp EndBut

Event1:




EndBut:	ret

;**************************************************
;**************************************************
TIM_COMP1:
;Timer-Counter1 compare interrupt process
;output: DecCount - number of current 1/10 sec.



	push Temp
	in Temp,SREG
	push Temp
	push Temp1
	push Temp2
	push Temp3
	push Temp4



	inc DecCount
;	rcall PWMctrl

	cpi DecCount,5
	breq HalfSec
	cpi DecCount,10
	brne End_Tim_comp1
	ldi DecCount,0
	ori Status,0b11000000
	sbi PortD,6
              rjmp End_Tim_comp1
HalfSec:	andi Status,0b10111111
	cbi PortD,6

End_Tim_comp1:
	wdr
	pop Temp4
	pop Temp3
	pop Temp2
	pop Temp1
	pop Temp
	out SREG,Temp
	pop Temp
	reti


;**************************************************
TimReset:
	ldi Temp1,0

	out TCNT1H,Temp1
	out TCNT1L,Temp1

	clr DecCount

	ret
;**************************************************
;**************************************************
Secund:
;new secund process
;input: -
;outputs:	Scd - counter of seconds
;	Min - -//- minuts
;	Hour - -//- hours


	inc Scd
	cpi Scd,60
	brne EndSecund
	clr Scd
	rcall MinInc

	cpi Min,0
	brne EndSecund
	rcall HourInc

EndSecund:	ret


;**************************************************
MinInc:
;increment minute
	inc Min
	cpi Min,60
	brne EndMinInc
	clr Min

EndMinInc:	ret

;**************************************************
HourInc:
;increment hour

	inc Hour
	cpi Hour,24
	brne EndHourInc
	clr Hour

EndHourInc:	ret

;**************************************************
LineDecoder1:
;decoder for minutes
;input: temp1-number of lighting LEDs

              andi Status,0b11011111

	rcall GetLine1
	sts Line0,Temp2

	rcall GetLine1
	sts Line1,Temp2

	rcall GetLine1
	sts Line2,Temp2

	rcall GetLine1
	sts Line3,Temp2

	rcall GetLine1
	sts Line4,Temp2

	rcall GetLine1
	sts Line5,Temp2

	rcall GetLine1
	sts Line6,Temp2

	rcall GetLine1
	sts Line7,Temp2

	ret

GetLine1:	cpi Temp1,8
	brmi DetailLn1
	subi Temp1,8
	ldi Temp2,0xff
EndGetLn1:	ret


DetailLn1:	sbrc Status,5
	rjmp ZeroLine1

	ldi ZL,Low(DetLine1*2)
	ldi ZH,High(DetLine1*2)

	ldi Temp3,0
	add ZL,Temp1
	adc Zh,Temp3

	lpm
	mov Temp2,r0
	ori Status,0b00100000
	rjmp EndGetLn1

ZeroLine1:	ldi Temp2,0
	rjmp EndGetLn1

DetLine1:
	.db 0b10000000,0b11000000
	.db 0b11100000,0b11110000
	.db 0b11111000,0b11111100
	.db 0b11111110,0b11111111

;**************************************************
LineDecoder2:
;decoder for minutes
;input: temp1-number of lighting LEDs

	andi Status,0b11011111

	lds Temp2,Line0
	rcall GetLine2
	sts Line0,Temp2

              lds Temp2,Line1
	rcall GetLine2
	sts Line1,Temp2

	lds Temp2,Line2
	rcall GetLine2
	sts Line2,Temp2

	lds Temp2,Line3
	rcall GetLine2
	sts Line3,Temp2

	lds Temp2,Line4
	rcall GetLine2
	sts Line4,Temp2

	lds Temp2,Line5
	rcall GetLine2
	sts Line5,Temp2

	lds Temp2,Line6
	rcall GetLine2
	sts Line6,Temp2

	lds Temp2,Line7
	rcall GetLine2
	sts Line7,Temp2

	ret

GetLine2:	cpi Temp1,8
	brmi DetailLn2
	subi Temp1,8
EndGetLn2:	ret


DetailLn2:	sbrc Status,5
	rjmp ZeroLine2

	ldi ZL,Low(DetLine2*2)
	ldi ZH,High(DetLine2*2)

	ldi Temp3,0
	add ZL,Temp1
	adc Zh,Temp3

	lpm
	mov Temp3,r0
	eor Temp2,Temp3
	ori Status,0b00100000
	rjmp EndGetLn2

ZeroLine2:	rjmp EndGetLn2

DetLine2:
	.db 0b10000000,0b01000000
	.db 0b00100000,0b00010000
	.db 0b00001000,0b00000100
	.db 0b00000010,0b00000001


;*********************************************************
LineDecoder3:
	andi Status,0b11011111

	cpi Temp1,12
	brmi ContDc3
	subi Temp1,12

ContDc3:	rcall GetLine3
	sts Line8,Temp2

	rcall GetLine3
	sts Line9,Temp2

	ret

GetLine3:	cpi Temp1,8
	brmi DetailLn3
	subi Temp1,8
	ldi Temp2,0xff
EndGetLn3:	ret


DetailLn3:	sbrc Status,5
	rjmp ZeroLine3

	ldi ZL,Low(DetLine1*2)
	ldi ZH,High(DetLine1*2)

	ldi Temp3,0
	add ZL,Temp1
	adc Zh,Temp3

	lpm
	mov Temp2,r0
	ori Status,0b00100000
	rjmp EndGetLn3

ZeroLine3:	ldi Temp2,0
	rjmp EndGetLn3







;*********************************************************
SendAdd:
	in Temp2,PortD
	andi Temp2,0b11000011
	or Temp2,Temp1
	out PortD,Temp2
	ret

;*********************************************************
;*********************************************************
SegmentOut:
	rcall BinToDec
	rcall Segment
	ret

;*********************************************************
BinToDec:
;decoder binary time format to binary-decimale format
;input - cells: Min, Hour
;output - cells: HourH, HourL, MinH, MinL

	mov Temp1,Hour
	rcall BDLoop
	sts HourH,Temp2
	sts HourL,Temp3

	mov Temp1,Min
	rcall BDLoop
	sts MinH,Temp2
	sts MinL,Temp3


BDLoop:	ldi Temp2,0
	ldi Temp3,0

High_:	cpi Temp1,10
	brmi Low_
	inc Temp2
	subi Temp1,10
	rjmp High_

Low_:	cpi Temp1,0
	breq EndBD
	inc Temp3
	dec Temp1
	rjmp Low_

EndBD:	ret


;*********************************************************
Segment:
;sending data to LED 7-segment display
;input - cells: HourH, HourL, MinH, MinL
;output - cells: Line10...13
;output format: hgfedcba

	lds Temp1,HourH
	rcall SendDispl
	cpi Temp1,0b00111111
	brne ContHourH
	ldi Temp1,0x00000000
ContHourH:	sts Line10,Temp1

	lds Temp1,HourL
	rcall SendDispl
	sts Line11,Temp1

	lds Temp1,MinH
	rcall SendDispl
	sts Line12,Temp1

	lds Temp1,MinL
	rcall SendDispl
	sts Line13,Temp1

	ret

SendDispl:
	ldi ZL,Low(DcMatrix*2)
	ldi ZH,High(DcMatrix*2)

	ldi Temp2,0
	add ZL,Temp1
	adc ZH,Temp2

	lpm
	mov Temp1,r0
	ret

DcMatrix:
	;     hgfedcba   hgfedcba
	.db 0b00111111,0b00000110	;0,1
	.db 0b01011011,0b01001111	;2,3
      	.db 0b01100110,0b01101101	;4,5
	.db 0b01111101,0b00000111	;6,7
	.db 0b01111111,0b01101111	;8,9

;*********************************************************


