;  PIC16F84
;         
 list P=16F84A
 #INCLUDE p16F84A.INC
#define TIR1	 PORTA,0    ; 
#define TIR2	 PORTA,1    ;  
#define SIRENA	 PORTA,2
#define LED	 PORTA,3
#define LED_PRO	 PORTA,4
#define TM	 PORTB,0
#define SMK	 PORTB,3
#define REC	 PORTB,4
#define ERASE	 PORTB,5
;  
CODKEY1	EQU	0Ch		;     
CODKEY2	EQU	0Dh		; 
CODKEY3	EQU	0Eh
CODKEY4	EQU	0Fh
CODKEY5	EQU	10h
CODKEY6	EQU	11h
CODKEY7	EQU	12h
CODKEY8	EQU	13h
TM1    	EQU 	14h             	;
TM2    	EQU 	15h             	;
TM3    	EQU 	16h            	;
TM4    	EQU 	17h             	;
TM5    	EQU 	18h		;
BYTE   	EQU 	19h
RPZU	EQU	1Ah
PZUDAT	EQU 	1Bh		;    EEPROM  
ADR	EQU	1Ch		;    EEPROM
FLAG	EQU	1Dh		;      
REP    	EQU 	1Fh		; -  
REP1   	EQU 	20h
TM6    	EQU 	21h
TM7    	EQU 	22h
CRC	EQU 	23h
TEMP	EQU 	24h
BIT_CNT	EQU 	25h
SAVE_W	EQU 	26h

;**********************************************************************************************************************************
        ORG 0 			; .
        GOTO    BEGIN 
;**********************************************************************************************************************************
;
	ORG	0x04
	RETFIE	
;**********************************************************************************************************************************
;  
;**********************************************************************************************************************************
;  
BEGIN        BCF	INTCON,GIE	 ;  
	BCF     	STATUS,RP0       	;  0
        	CLRF    	PORTA        	 ;  PORTOUT
       	MOVLW   0X00            	 ;p B'00000000'  pp W
	BSF     	STATUS,RP0
       	MOVWF   	TRISA          	 ;      
;  	
        	BCF     	STATUS,RP0      	 ;  0
        	CLRF    	PORTB         	 ;  PORTIN
        	MOVLW   0xFF            	 ;p B'11111111'  pp W
	BSF    	STATUS,RP0
       	MOVWF    TRISB         	 ;       
	BCF     	STATUS,RP0
	CLRF	FLAG
	BTFSS	REC		;  
	GOTO	PROG2		;      
	BTFSS	ERASE		;      
	GOTO	ERASING		;    
	MOVLW    0x39		;   
	MOVWF	EEADR
	BSF	STATUS,RP0
	BSF	EECON1,0
	BCF	STATUS,RP0
	BCF	STATUS,C	
	BTFSC   	EEDATA,0		
	GOTO	PROV		;    
	BTFSC   	EEDATA,1
	GOTO	GUARD0		;   
	GOTO	LIGNT0		;   	
;*****************************************************************************
; ""         *
;      , 			     * 
;      				     * 
;*****************************************************************************
LIGNT	CALL	POTV		;     
	BSF	SIRENA		;    
	CALL	POTV
	BCF	SIRENA
	BCF	LED
	BCF	FLAG,1
	MOVLW	0x00
	MOVWF	EEDATA
	MOVLW	0x39
	MOVWF	EEADR
	CALL	WRITE_EE
	CALL	ZAPRET		;  
LIGNT0	BTFSS	REC		;  
	GOTO	PROG		;      
	BTFSS	ERASE		;      
	GOTO	ERASING		;    
	CALL	INI		;  	
	BTFSS	FLAG,1		;   
	GOTO	LIGNT2		;     
	GOTO	GUARD
LIGNT2	BTFSC	SMK		; 
	GOTO	VKL		;   
	BTFSS	FLAG,2		;-    
	GOTO	LIGNT0		; 
	GOTO	VKL1		;    
VKL	BSF	FLAG,2		;   
	CLRF	TM4
	MOVLW	0xFF
	MOVWF	TM5
	BSF	PORTA,0		;     
	BSF	PORTA,1
VKL1	DECFSZ  	TM4,1		;   
	GOTO	LIGNT0		;    
	DECFSZ  	TM5,1
	GOTO	LIGNT0
	BCF	PORTA,0		;  
	BCF	PORTA,1
	BCF	FLAG,2		; ,  
	GOTO	LIGNT0		;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    
;*******************************************************************************
; :        . 
;       .
; ,       
; ,    .
;*******************************************************************************
GUARD	MOVLW	0x02
	MOVWF	EEDATA
	MOVLW	0x39
	MOVWF	EEADR
	CALL	WRITE_EE
	BCF	FLAG,1	
	BSF	LED
	CALL	ZAPRET
	BCF	LED
GUARD9	BTFSS	SMK		;    
	GOTO	GUARD11
	CALL	INI		;  
	BTFSS	FLAG,1		;   
	GOTO	GUARD9		;     
	GOTO	LIGNT
GUARD11	BCF	TIR2
	BCF	TIR1
	BSF	LED		; 
	BSF	SIRENA
	CALL	POTV
	BCF	SIRENA
GUARD0	BSF	LED
GUARD00	CLRWDT
	MOVLW	0xFF
	OPTION	
	BCF	FLAG,1
	BTFSC	SMK		;   
	GOTO	ALARM		;   
	CALL	INI		;  
	BTFSC	FLAG,1		;   
	GOTO	LIGNT		;        .
	GOTO	GUARD00		;      
;*******************************************************************************
;!!! !!! !!! !!! !!! !!!
;*******************************************************************************
ALARM	CLRWDT
	MOVLW	0xFF
	OPTION	
	BSF	TIR2
	BSF	TIR1
	MOVLW	0x03
	MOVWF	TM7
ALARM3	BSF	SIRENA		; 
	BCF	LED		; 
	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	AL1		;     
	GOTO	LIGNT
AL1	BSF	LED		; 
	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	AL2		;     
	GOTO	LIGNT
AL2	DECFSZ	TM6,1
	GOTO	ALARM3
	DECFSZ	TM7,1
	GOTO	ALARM3	
	BCF	SIRENA		; 
	GOTO	PROVV
;**************************************************************************************
;      .
;**************************************************************************************
PROVV	MOVLW	0x01
	MOVWF	EEDATA
	MOVLW	0x39
	MOVWF	EEADR
	CALL	WRITE_EE
PROV	CLRWDT
	MOVLW	0xFF
	OPTION	
	BSF	LED		; 
	BCF	SIRENA
	BTFSS	SMK		; 
	GOTO	PROV2		
	GOTO	PROV1		;
PROV1	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	PROV2		;     
	GOTO	LIGNT		
PROV2	BCF 	LED		; 
	BTFSS	SMK		; 
	GOTO	GUARD19		;   
	GOTO	PROV3			;      
PROV3	CALL	DELAY		;  
	BTFSS	FLAG,1		;   
	GOTO	PROV		;     
	GOTO	LIGNT
;**************************************************************************************
;     c  
;**************************************************************************************
GUARD19	BCF	TIR2
	BCF	TIR1	
GUARD1	CLRWDT
	MOVLW	0xFF
	OPTION	
	BTFSC	SMK		; 
	GOTO	ALARM		;   
	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	GUARD2		;     
	BTFSS	FLAG,1		;   
	GOTO	GUARD2		;     
	BTFSS	FLAG,1		;   
	GOTO	GUARD2		;     		
	GOTO	LIGNT		;    
GUARD2	BCF	LED		; 
	CLRWDT
	MOVLW	0xFF
	OPTION	
GUARD3	BTFSC	SMK		; 
	GOTO	ALARM		;   
	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	GUARD4		;     
	GOTO	LIGNT
GUARD4	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	GUARD5		;     
	GOTO	LIGNT	
GUARD5	CALL	DELAY
	BTFSS	FLAG,1		;   
	GOTO	GUARD6		;     
	GOTO	LIGNT	
GUARD6	BSF	LED		; 
	GOTO	GUARD1
;*********************************************************************************
;         
;*********************************************************************************
INI	CALL	INPUT
	CALL	D312	
	CALL	OUT		;
	CALL	D500		; 500 
	CALL	INPUT		; 
	CALL	D14
	BTFSS	TM		;  0
	GOTO	INI2		;    0
	CALL	D66		;
	BTFSS	TM		;    
	GOTO	INI1
	GOTO	INI2
INI1	CALL	D312
	BTFSS	TM		; .
	GOTO	INI2
	CALL	R33		;   
	CALL	RDDATA		;  
	CALL	CNT_CRC
	BTFSS	FLAG,2
	GOTO	INI2
	CALL	PROVER		; , 
INI2	CALL	OUT	
	RETURN			;   

;*********************************************************************************
;    
;*********************************************************************************
R33	MOVLW	0x33		;  
	MOVWF	RPZU
	MOVLW	0x08
	MOVWF	REP
RD1	CALL	OUT		;
	BTFSS	RPZU,0
	GOTO	RD_0		;   0
	GOTO	RD_1		;   1
RD_0	CALL	D66		; 0    60 
	GOTO	RD2
RD_1	NOP
	NOP
	NOP
	NOP
	NOP
	CALL	INPUT		; 1
	CALL	D66		;  
	GOTO	RD3
RD4	NOP			;   
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO	RD1		;  
RD2	CALL	INPUT		; .
RD3	RRF	RPZU,1
	DECFSZ	REP,1
	GOTO	RD4
	CALL	D66
	RETURN			;  
;*********************************************************************************
;   
;*********************************************************************************
RDDATA	BCF	STATUS,C	
RDKEY  	MOVLW	0x0C
	MOVWF	FSR
	MOVLW	0x08
	MOVWF	REP
	CLRF	EEADR
RDKEY1	CALL	RDBYT
	MOVF	BYTE,0		;   
	MOVWF	INDF		;     
	INCF	FSR,1		;    
	DECFSZ	REP,1		;  ?
	GOTO	RDKEY1		;,    
	RETURN
RDBYT	MOVLW	0x08		;   
	MOVWF	REP1		; 
RDBYT1	CALL	OUT		;
	NOP
	NOP
	NOP
	NOP
	CALL	INPUT		; 
	CALL	D14
	BTFSS	TM		; 
	GOTO	BYT0		; 0     0
	BSF	BYTE,7
	GOTO	SDVIG
BYT0	BCF	BYTE,7
SDVIG	RRF	BYTE,1		; 
	CALL	D66		; -
	DECFSZ	REP1,1
	GOTO	RDBYT1
	RLF	BYTE,1
	RETURN
;*********************************************************************************
; c      
;*********************************************************************************
PROVER	CLRF	ADR		;
	GOTO	SR2
SR1	MOVLW	0x08		;  
	ADDWF	ADR,1
	MOVLW	0x38		;  
	SUBWF	ADR,0		;
	BTFSS	STATUS,Z
	GOTO	SR2
	BCF	FLAG,1
	CALL	OUT		;      1 .
	CALL	D312		;    
	BSF	SIRENA
	CALL	ZAPRET		; .
	BCF	SIRENA
	RETURN			;    
SR2	MOVLW	0x0C
	MOVWF	FSR
	MOVF	ADR,0
	MOVWF	EEADR
	MOVLW	0x08
	MOVWF	REP	
SR3	BSF	STATUS,RP0
	BSF	EECON1,0
	BCF	STATUS,RP0
	BCF	STATUS,C	
	MOVF    	EEDATA,0
	SUBWF	INDF,0
	BTFSS	STATUS,Z
	GOTO	SR1
	INCF	FSR,1
	INCF	EEADR,1
	DECFSZ	REP,1
	GOTO	SR3
	MOVLW	0x00
	MOVWF	CODKEY1	
	MOVWF	CODKEY2	
	MOVWF	CODKEY3	
	MOVWF	CODKEY4	
	MOVWF	CODKEY5	
	MOVWF	CODKEY6	
	MOVWF	CODKEY7	
	MOVWF	CODKEY8	
	BSF	FLAG,1		;       
	BSF	SIRENA		;    
	CALL	POTV
	BCF	SIRENA
	RETURN
;********************************************************************************
;  
;*********************************************************************************
;    0,59  
DELAY	CLRWDT
	MOVLW	0xFF
	OPTION	
	CLRF	TM1
	CLRF	TM2
	MOVLW	0xA0
	MOVWF	TM3
DELAY1	DECFSZ	TM1,1
	GOTO	DEL
	GOTO	DEL1
DEL	CALL	INI
	BTFSS	FLAG,1		;   
	GOTO	DEL1		;     
	RETURN
DEL1	DECFSZ	TM3,1
	GOTO	DELAY1
	RETURN
;*********************************************************************************
;  
;*********************************************************************************
D500	MOVLW	0x06		;6
	MOVWF	TM2
D1	MOVWF	TM1
D2	DECFSZ	TM1,1
	GOTO	D2
	DECFSZ	TM2,1
	GOTO	D1
	MOVLW	0x07
	MOVWF	TM2
D4	MOVWF	TM1
D3	DECFSZ	TM1,1
	GOTO	D3
	DECFSZ	TM2,1
	GOTO	D4
D312	MOVLW	0x04
	MOVWF	TM2
D5	MOVWF	TM1
D6	DECFSZ	TM1,1
	GOTO	D6
	DECFSZ	TM2,1
	GOTO	D5
	MOVLW	0x05
	MOVWF	TM2
D7	MOVWF	TM1
D8	DECFSZ	TM1,1
	GOTO	D8
	DECFSZ	TM2,1
	GOTO	D7
D66	MOVLW	0x04		;4
	MOVWF	TM2
D662	MOVWF	TM1
D661	DECFSZ	TM1,1
	GOTO	D661
	DECFSZ	TM2,1
	GOTO	D662
D14	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	CLRWDT
	MOVLW	0xFF
	OPTION	
	RETURN
;*********************************************************************************

;***********************************************************************************
;          0
OUT	BCF	TM
	BSF	STATUS,RP0
	BCF	TRISB,0
	BCF	STATUS,RP0
	BCF	TM
	RETURN
;**********************************************************************************
;             1
INPUT	BSF	STATUS,RP0
	BSF	TRISB,0
	BCF	STATUS,RP0
	RETURN
;**********************************************************************************
;      
; ,     1     
;**********************************************************************************
ZAPRET	CLRF	TM1
	CLRF	TM2
	MOVLW	0x05
	MOVWF	TM3
Z1	DECFSZ	TM1,1
	GOTO	Z1
	DECFSZ	TM2,1
	GOTO	Z1
	CLRWDT
	MOVLW	0xFF
	OPTION	
	DECFSZ	TM3,1
	GOTO	Z1
	RETURN
;**********************************************************************************
;  
;**********************************************************************************
POTV	CLRF	TM1
	CLRF	TM2
	MOVLW	0x01
	MOVWF	TM3
P1	DECFSZ	TM1,1
	GOTO	P1
	CLRWDT	
	MOVLW	0xFF
	OPTION	
	DECFSZ	TM2,1
	GOTO	P1
	DECFSZ	TM3,1
	GOTO	P1
	RETURN
;*********************************************************************************
;      
;*********************************************************************************
PROG2	CLRF	TM6
	CLRF	TM7
	BTFSS	REC
	GOTO	PROG2
	GOTO	PROG1
PROG1	DECFSZ	TM7,1
	GOTO	PROG
	DECFSZ	TM6,1
	GOTO	PROG
	BSF	SIRENA
	CALL	POTV
	BCF	SIRENA
	BCF	LED
	GOTO	LIGNT0			
PROG	BSF	LED
	BCF	FLAG,2
	CALL	INPUT
	CALL	D66
PINI	CALL	OUT		;
	CALL	D500		; 500 
	CALL	INPUT		; 
	CALL	D14
	BTFSS	TM		;  0
	GOTO	PROG1		;    0
	CALL	D66		;
	BTFSS	TM		;    
	GOTO	PINI1
	GOTO	PROG1
PINI1	CALL	D312
	BTFSS	TM		; .
	GOTO	PROG1
	CALL	R33		;   
	CALL	RDDATA		;  
	CALL	CNT_CRC
	BTFSS	FLAG,2
	GOTO	PROG1		;  , 
	GOTO	PROGG		;  , 
;*********************************************************************************	
;   	
PROGG	MOVLW 	0X38		;      
	MOVWF	EEADR		;    .  
	BSF	STATUS,RP0
	BSF 	EECON1,0
	BCF	STATUS,RP0
	SUBWF	EEDATA,0		;   
	BTFSS	STATUS,Z
	GOTO	TRE
	CLRF	EEDATA
TRE	MOVF	EEDATA,0
	MOVWF	EEADR
	MOVLW	0x08
	MOVWF	REP	
	MOVLW	0x0C
	MOVWF	FSR
REE	MOVF	INDF,0
	MOVWF	EEDATA		;   
	CALL	WRITE_EE
	INCF	FSR,1		
	INCF	EEADR,1		
	DECFSZ	REP,1
	GOTO	REE
	MOVF	EEADR,0
	MOVWF	EEDATA
	MOVLW 	0X38		;      
	MOVWF	EEADR
	CALL	WRITE_EE
	BSF	SIRENA
	CALL	POTV
	BCF	SIRENA
	BCF	LED
	CALL	POTV
	BSF	LED
	GOTO	PROG2
;*********************************************************************************************************************
; 
WRITE_EE	BSF	STATUS,RP0
	BSF	EECON1,WREN
	BCF	EECON1,0
	BCF	INTCON,GIE	;
	MOVLW 	0X55
	MOVWF 	EECON2
	MOVLW 	0XAA
	MOVWF 	EECON2
	BSF 	EECON1,WR
	BCF	EECON1,WREN
	BTFSS	EECON1,4
	GOTO	$-1
	BCF	EECON1,4
	BCF	STATUS,RP0
	RETURN
;*********************************************************************************************************************	
;  ,    00
;   ,  
ERASING	MOVLW	0x00
	MOVWF	EEADR
	MOVWF	EEDATA
	MOVLW	0x3F
	MOVWF	REP
ERASS	CALL	WRITE_EE
	INCF	EEADR,1
	DECFSZ	REP,1
	GOTO	ERASS
	BSF	SIRENA	
	BSF	LED
	CALL	POTV
	BCF	SIRENA
	BCF	LED
	CALL	ZAPRET
	GOTO	PROG2

;*****************************************************************************************************************************
;  CRC
;*****************************************************************************************************************************
CNT_CRC	CLRF	CRC
	BCF	FLAG,2
	MOVF	CODKEY1,0
	MOVWF	SAVE_W
	CALL	DO_CRC
	MOVF	CODKEY2,0
	MOVWF	SAVE_W
	CALL	DO_CRC	
	MOVF	CODKEY3,0
	MOVWF	SAVE_W
	CALL	DO_CRC
	MOVF	CODKEY4,0
	MOVWF	SAVE_W
	CALL	DO_CRC	
	MOVF	CODKEY5,0
	MOVWF	SAVE_W
	CALL	DO_CRC
	MOVF	CODKEY6,0
	MOVWF	SAVE_W
	CALL	DO_CRC	
	MOVF	CODKEY7,0
	MOVWF	SAVE_W
	CALL	DO_CRC
	MOVF	CODKEY8,0
	MOVWF	SAVE_W
	CALL	DO_CRC
	MOVLW	0x00		;  
	SUBWF	CRC,0		;
	BTFSC	STATUS,Z
	BSF	FLAG,2
	RETURN	
DO_CRC   	MOVLW	0x08
	MOVWF	BIT_CNT
	MOVF	SAVE_W,0
DO_CRC1	XORWF	CRC,0
	MOVWF	TEMP
	RRF	TEMP,0
	MOVF	CRC,0
	BTFSC	STATUS,0
	XORLW	0x18
	MOVWF	TEMP	
	RRF	TEMP,0
	MOVWF	CRC				
	BCF 	STATUS,0
	RRF	SAVE_W,1
	MOVF	SAVE_W,0
	DECFSZ	BIT_CNT,1
	GOTO	DO_CRC1
	RETURN
	END
;*****************************************************************************************************************************		
;   !!!	
;*****************************************************************************************************************************	
	
	
