
                                          ;   
                                                        
                                                      
  processor 12f675  
  include <p12F675.inc>
        
  org    h'0000'
  goto   MAIN
  org    h'0004'
  goto   INTERRUPT 
          
   __CONFIG  3F84H          ;  RC  
   errorlevel-302
 CBLOCK  20H
TEMP
I_BYTE
_N
MSB
O_BYTE
LSB
LSB_15
_2  
_3
_4
 _20
RT 
LOOP1    
LOOP2
sec_60
W_TEMP        
S_TEMP
ADC_H
ADC_L
ADC_L1v
ADC_H1v
FLAG                ; 0-  
                          ; 1-    
		              ; 2-  15 
		              ; 3-     
                          ; 4-    
                          ; 5-   	
                          ; 6-  
                          ; 7-   	
 ENDC

      ; 
SIGNAL      EQU  5
GREEN       EQU  1
RED            EQU  0
DATA_PIN EQU  2

; 
MAIN
        bsf         STATUS, RP0  	 ;   1- 
        CALL   h'3FF'
        ;movlw   h'6C'                    
        movwf   OSCCAL
        movlw   b'11011100'  	     ;  2,3   ,
        movwf   TRISIO         	     ;     
        clrf        PIE1
        bsf        PIE1, TMR1IE      ;   TMR1 
        movlw   b'00111000'   	    ;  RC 
        movwf   ANSEL          	    ;  3-.,  
        bcf	   STATUS, RP0       ;   0- 
        clrf        GPIO
        clrf        FLAG
        bsf         FLAG, 7 
        clrf        INTCON   
        movlw   .7
        movwf   CMCON                ;   
        movlw   .3
        movwf   _3
        movlw   .4
        movwf   _4 
        movlw   .15
        movwf   LSB_15
        movlw   .60
        movwf   sec_60
        movlw   .180                     
        movwf   ADC_L1v
        clrf        ADC_H1v
      
                                                           ;  TMR1
;--------------------------------------------------------------------
	  CALL    CONST
        movlw   b'00100001'      ;   TMR1   
        movwf   T1CON            ;    1:4
        movlw   .5               
        movwf   RT
        movlw   b'01000000'     ;   
        movwf   INTCON            
       
                   
                                                    ;   
;--------------------------------------------------------------------------------------------------    
CYCLE
        CALL    IZMER_T
        CALL   DOOR 
        CALL   v1
        btfsc     FLAG, 5             ;  ?
        goto      SIG_DOOR
        btfsc     FLAG, 0             ;   ?
        goto      TEMPER          ; ,   
        bcf        GPIO, RED  
        bsf        GPIO, GREEN  ;   ,  .-
        clrf        FLAG
        movlw   .60
        movwf   sec_60           
        movlw   .5               
        movwf   RT
        bcf         INTCON, 7       ;   
        movlw   .3
        movwf   _3 
        movlw   .4
        movwf   _4
        goto      CYCLE

;--------------------------------------------------------------------------------------------
TEMPER
         bcf      GPIO, GREEN 
         bsf      GPIO, RED
         btfsc   FLAG, 3                          ;    ?
         goto    CYCLE                           ; 
         CALL   _1sec 
         decfsz    sec_60, F
         goto       CYCLE
         movlw   .60
         movwf   sec_60          ;    60          
         decfsz  _4, F
         goto    SIG_T
         movlw   .4
         movwf   _4
         bsf       FLAG, 3                         ;    
         goto      CYCLE                          ; 
SIG_T 
        bsf        GPIO, SIGNAL
        CALL   _1sec                             ; 1 
        bcf        GPIO, SIGNAL 
        CALL   _1sec   
        bsf        GPIO, SIGNAL
        CALL   _1sec                             ; 2 
        bcf        GPIO, SIGNAL
        CALL   _1sec 
        bsf        GPIO, SIGNAL
        CALL   _1sec                             ; 3 
        bcf        GPIO, SIGNAL
        CALL   _1sec 
        goto      CYCLE                                            

                     

;-------------------------------------------------------------------------------------------
SIG_DOOR
     
        bsf         INTCON, 7                         ;    
        bcf         GPIO, GREEN             
        bsf         GPIO, RED
        CALL   DELAY_250       
        CALL   DELAY_250
        btfsc      FLAG, 1                           ;     ?
        goto       m0                   
        btfss      FLAG, 2                           ;   20 ?
        goto       m3
        bsf         GPIO, SIGNAL               ;  
        btfss      FLAG, 6                           ;  ?
        goto       m3 
        bcf         FLAG, 6 
        decfsz   _3, F
        goto      m3
        movlw   .3
        movwf   _3 
        bsf        FLAG, 1
        bcf          GPIO, SIGNAL  
        bcf         INTCON, 7
m3  
        bcf          GPIO, RED
        CALL    DELAY_250
        bcf          GPIO, SIGNAL         
        CALL    DELAY_250
        goto       CYCLE
m0
        btfss     FLAG, 0            ;   ?
        goto       m3
        bcf         INTCON, 7
        btfsc      FLAG, 4           ;    ?
        goto       TEMPER 
        movlw   .60
        movwf   sec_60                ;    60          
        bsf         FLAG, 4              ;    
        goto      TEMPER        

                    ;   
;==========================================================
                      ;    TMR1

INTERRUPT
        movwf   W_TEMP          ;  
        swapf   STATUS, W       ; W, STATUS
        movwf   S_TEMP          ; 

        bcf     PIR1, TMR1IF     ;    TMR1
        
        decfsz  RT, F
        goto    m4
        movlw   .5                     ;  
        movwf   RT
        movfw   sec_60            ;  sec_60
        xorlw   .16                    ;   15  
        bnz       $+2                   ; ,,   
        bsf     FLAG, 2             ; ,    15  
        decfsz  sec_60, F         ;  60 
        goto    m4
        movlw   .60
        movwf   sec_60           ;    60 
        bcf        FLAG, 2
        bsf        FLAG, 6
        
m4
        CALL    CONST              
        
        swapf   S_TEMP, W       ;  
        movwf   STATUS          ; W, STATUS 
        swapf   W_TEMP, F       ;
        swapf   W_TEMP, W 

        retfie

         
                      ;      TMR1
;----------------------------------------------------------------------------------------------------------------------
CONST
        movlw   .60             ;      
        movwf   TMR1H       ;    TMR1
        movlw   .108           
        movwf   TMR1L
        return
;--------------------------------------------------------------------------------------------------    
v1
                    ;        
                  
        movf    ADC_H1v, W     	  ;   
        subwf   ADC_H, W      	  ;  
        movwf   _2           		  ;    
                
        movf    ADC_L1v, W    	  ;     
        subwf   ADC_L, W      	  ;  
        btfss   STATUS, C     		  ;   
        decf    _2, F          		  ;  
        iorwf   _2, W        			  ;   0
        btfsc   STATUS, Z    		  ;  ,  
        goto    EL            		  ;  , 
        btfsc   _2, 7                		  ;   , 
                                         		  ;  
        goto    EL  		              ;    
        bsf     FLAG, 5                   ;     
        return
EL  
        bcf       FLAG, 5                  ;   
        return      

;---------------------------------------------------------------------------------------------------
DOOR      
        movlw     b'10001101'     	    ;   ,  AN3,
        movwf     ADCON0         	    ; - ,  ,
        goto        $+1                            ;     
        goto        $+1                            ;  C_ hold 
        goto        $+1 
        clrwdt     
        bsf          ADCON0,1   		    ;  
        btfsc        ADCON0, 1  	          ;  ?
        goto        $-1           		          ; , 
        clrwdt
        movfw    ADRESH      		    ;  , 
        movwf    ADC_H        		    ;   
        bsf          STATUS, RP0 	          ;   1- 
        movfw    ADRESL
        bcf	    STATUS, RP0  	          ;   0- 
        movwf    ADC_L  
        return
               
;---------------------------------------------------------------------------------------------------------
IZMER_T        
        CALL    START_DS       ;                      
        CALL    READ_T           ;             
        btfss       MSB, 0              ;  ? 
        goto      $+3                       
        bcf        FLAG, 0
        return 
                         ;        1  

        rrf         LSB, F               ;    
        btfss     LSB, 7               ; 0,5  ?
        goto      $+3
        bcf        LSB, 7 
        incf       LSB, F               ; ,    
        CALL  C_15                  ;   15 
        return 

                                
;---------------------------------------------------------------------------------------
DELAY_250:
        MOVLW 	.250     		 ;  250 
DELAY_N_MS:
        MOVWF 	LOOP1
OUTTER:
        MOVLW   .110     		 ;  1 
        MOVWF   LOOP2
INNER:
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        DECFSZ  LOOP2, F
        GOTO 	INNER
        DECFSZ  LOOP1, F
        GOTO 	OUTTER
        RETURN

       
  
                  ;        
;-------------------------------------------------------------------------------
READ_T	        
      CALL	INIT
	MOVLW	0xCC		;   
	MOVWF	O_BYTE
	CALL	OUT_BYTE
	MOVLW	0xBE		;    
	MOVWF	O_BYTE
	CALL	OUT_BYTE
	                	    ;  
	CALL 	IN_BYTE
	MOVWF	LSB     	;    
	CALL 	IN_BYTE
	MOVWF	MSB     	;    
	CALL    PIN_LO          ;    
      return
               

                     ;      
;--------------------------------------------------------------------------------------- 
START_DS
	CALL	INIT
	MOVLW	0xCC		;   
	MOVWF	O_BYTE
      CALL	OUT_BYTE
	MOVLW	0x44		;   
	MOVWF	O_BYTE
	CALL	OUT_BYTE
	RETLW	0xFF

;-------------------------------------------------------------------------------
                     ;     1-Wire
;-----------------------------------------------------------------------------------
INIT:
        CALL    PIN_HI
        CALL    PIN_LO
        MOVLW   .50              ;  500  
        CALL 	DELAY_10USEC
        CALL    PIN_HI
        MOVLW   .50              ;  500 
        CALL 	DELAY_10USEC
        RETURN

;------------------------------------------------------------------------------
IN_BYTE:              		;    W 
        MOVLW   .8
        MOVWF    _N
        CLRF    I_BYTE
IN_BYTE_1:
        CALL 	PIN_LO
        NOP
        CALL 	PIN_HI
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        MOVF    GPIO, W        
        MOVWF   TEMP
        BTFSS   TEMP, DATA_PIN
        BCF 	STATUS, C       
        BTFSC   TEMP, DATA_PIN
        BSF 	STATUS, C       
        RRF     I_BYTE, F
        MOVLW 	.6              
        CALL    DELAY_10USEC
        DECFSZ  _N, F
        GOTO    IN_BYTE_1
        MOVFW   I_BYTE          ;    W
        RETURN


;------------------------------------------
OUT_BYTE:
        MOVLW   .8
        MOVWF   _N
OUT_BYTE_1:
        RRF     O_BYTE, F
        BTFSS   STATUS, C
        GOTO    OUT_0
        GOTO    OUT_1
OUT_BYTE_2:
        DECFSZ  _N, F
        GOTO    OUT_BYTE_1
        RETURN

;-------------------------------------------
OUT_0:
        CALL    PIN_LO          
        MOVLW   .6              
        CALL    DELAY_10USEC
        CALL    PIN_HI
        GOTO    OUT_BYTE_2
OUT_1:
        CALL    PIN_LO          
        CALL    PIN_HI
        MOVLW 	.6
        CALL 	DELAY_10USEC
        GOTO    OUT_BYTE_2

;-----------------------------------------

PIN_HI:
        BSF     STATUS, RP0
        BSF     GPIO, DATA_PIN             ;   
        BCF     STATUS, RP0
        RETURN
;---------------------------------------
PIN_LO:
        BCF    GPIO, DATA_PIN
        BSF     STATUS, RP0
        BCF     GPIO, DATA_PIN              ;   
        BCF     STATUS, RP0
        RETURN

;---------------------------------------

DELAY_10USEC:   	                ;   W * 10 
        MOVWF 	LOOP1
DELAY_10USEC_1:
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        DECFSZ 	LOOP1, F
        GOTO 	DELAY_10USEC_1
        RETURN
;----------------------------------------------------------------------------------------------------
                               ;     
                               ;   15  
C_15
         movf     LSB, W
         subwf   LSB_15, W
         btfsc     STATUS, C
         goto      $+3
         bsf        FLAG, 0              ;    
         return       
         bcf        FLAG, 0
         return 
  ;------------------------------------------------------------------------------------------------
_1sec
       CALL   DELAY_250       
       CALL    DELAY_250                                      
       CALL   DELAY_250       
       CALL    DELAY_250 
       return
                                                    
        END
