
;  4096      

.include "8535def.inc"
;=======================================================

.equ    segG = 6 ; port C pin 28 
.equ    segF = 5 ; pin 27
.equ    segE = 4 ; pin 26
.equ    segD = 3 ; pin 25
.equ    segC = 2 ; pin 24
.equ    segB =1 ; pin 23
.equ    segA = 0 ; pin 22
                         
.equ    RazrDH = 6 ;  PortA,6 pin 34  
.equ    RazrEH = 5 ;  PortA,5 pin 35  
.equ    RazrDM = 4 ;  PortA,4 pin 36  
.equ    RazrEM = 3 ;  PortA,3 pin 37 
                                   
.equ    RazrTdH = 2 ;  PortB,2 pin 3
.equ    RazrTdM = 1 ;  PortB,1 pin 2
.equ    RazrTdL = 0 ;  PortB,0 pin 1
.equ    drv0	= 3 ; PortB,3, pin4 - .  1
.equ    drv1	= 4 ; PortB,4, pin5 - .  1

.equ    RazrPdH = 4 ;  PortD,4 pin 18
.equ    RazrPdM = 3 ;  PortD,3 pin 17
.equ    RazrPdL = 2 ;  PortD,2 pin 16  
.equ    kod1	= 6 ; PortD,6, pin20 -      1
.equ    kod2	= 7 ; PortD,7, pin21 -      1


.equ	const_W = 	0xA0;  
.equ	const_R = 	0xA1;  
.equ	const_E = 	0xA2;  
.equ	const_RAM = 	0xA3; RAM 
.equ	Const_TZ  = 	0xA4;;A4   T
.equ	Const_H	=	0xA5; 
.equ	Const_S0	=	0xA6; 
.equ	Const_59 =	0xA7;   59

; SRAM    SRAM=0x01
.equ	Tram	=	0x0 ; 0x0,0x1 -      
.equ	Pram	=	0x2 ; 0x2,0x3 -     
.equ	Bram	=	0x4 ; 0x4,0x5 -     
.equ	Tres	=	0x6 ; 0x6,0x7 -      
.equ	Pres	=	0x8 ; 0x8,0x9 -      
.equ	Bres	=	0x0A ; 0xA,0x0B -      
.equ	Hh	=	0x0C ; hex
.equ	Mh	=	0x0D ; hex
.equ	TdH	=	0x0E ;  
.equ	TdM	=	0x0F ;  
.equ	TdL	=	0x10 ;  
.equ	PdH	=	0x11 ;prs  
.equ	PdM	=	0x12 ;prs  
.equ	PdL	=	0x13 ;prs  
.equ	DdH	=	0x14 ;  
.equ	DeH	=	0x15 ;  
.equ	DdM	=	0x16 ;  
.equ	DeM	=	0x17 ;  

.equ	tZH	=	0x20;	.   Z 
.equ	tZL	=	0x21;	.   Z 
.equ	tKH	=	0x22;	.    
.equ	tKL	=	0x23;	.    
.equ	pZH	=	0x24;	.   Z  
.equ	pZL	=	0x25;	.   Z 
.equ	pKH	=	0x26;	.    
.equ	pKL	=	0x27;	.    
.equ	dQH	=	0x1A;	c     
.equ	dQL	=	0x1B;	.     

.equ	AtBCD0	=5		;address of ResL    Bin-Dec
.equ	AtBCD2	=6		;address of ResH
                                         
;
.def	AregH	= r01 ;  hex,  
.def	AregL	= r02  ;  hex,  
.def	KoeffH	= r03 ;,  
.def	KoeffL	= r04 ;,  
.def	ResL	= r05 ;   .,  
.def	ResH	= r06; ;   .,  

.def	temp	= r16 ;  
.def	temp1	= r17 ;    -                 
.def	temp2	= r18 ;    
.def	count	= r19;   -  64 
.def	countCyk	= r20 ;    -   32, 3264 = 2000    
.def	Flag		= r21;   :  0 - , 1 - , ,2- , 3-batLow ; 4- 
			; 5 -   () 
.def	cRazr	= r22;     10 
.def 	cSek	= r23 ;  sek
.def 	cMin		= r24 ;  min 
.def 	cHour	= r25 ;  hours

;====================================================================
;
        rjmp    RESET           ; Reset Handle
        reti	;INT_0 
        reti	;INT_1      External Interrupt1 Vector Address
        reti	;Timer_2 compare 
        reti	;Timer_2 ovflow  
        reti	;Timer_1 Capture
        rjmp	TIM1 ;Timer_1 compare A
        reti	;Timer_1 compare B
        reti	;Timer_1 ovflow 
        rjmp	TIM0	;Timer_0 ovflow 
        reti	;SPI serial tramsfer complete
        reti	;UART Rx complete
        reti	;UART Data Register Empty 
        reti	;UART Tx Transmit Complete
        rjmp readADC ;reti	;ADC conversion complete
        reti	;EEPROM ready
        reti	;Analog Comparator Interrupt Vector Address
;====================================================================

OUT_N: ; 
.db 0b00111111,0b00000110,0b01011011,0b01001111,0b01100110,0b01101101,0b01111101,0b00000111,0b01111111,0b01101111
;seg ABCDEF(0);seg BC(1);seg ABDEG(2);seg ABCDG(3);seg BCFG(4);seg ACDFG(5)
;seg ACDEFG(6);seg ABC(7);seg ABCDEFG(8);seg ABCDFG(9)
                                                                                                                                      
out_com:  ;   temp  . 
	sbis	USR,UDRE	;   
	rjmp	out_com
	out	UDR,temp
ret


in_com:   ;   temp  . 
	sbis	USR,RXC ;   
	rjmp	in_com
	in	temp,UDR
ret

Mp16: ;  16- 	
;    200    - !
;AregL multiplicand low byte
;AregH multiplicand high byte
;KoeffL multiplier low byte
;KoeffH multiplier high byte
;ResL result byte 0 (LSB)
;ResH result byte 1
;temp1 result byte 2
;temp2 result byte 3 (MSB)
;count	loop counter
	
	clr	temp2	;clear 2 highest bytes of result
	clr	temp1
	ldi	count,16	;init loop counter
m16u_1:	lsr	KoeffH
	ror	KoeffL
	brcc	noad8		;if bit 0 of multiplier set
	add	temp1,AregL	;add multiplicand Low to byte 2 of res
	adc	temp2,AregH	;add multiplicand high to byte 3 of res
noad8:	ror	temp2		;shift right result byte 3
	ror	temp1		;rotate right result byte 2
	ror	ResH		;rotate result byte 1 and multiplier High
	ror	ResL		;rotate result byte 0 and multiplier Low
	dec	count		;decrement loop counter
	brne	m16u_1		;if not done, loop more
ret
                
TIM1:                       ; 
	cpi	cSek,60
	breq	mcontinue                    ;  =60,   
	inc	cSek
	reti
mcontinue:	 ; =60      
	clr	cSek
	inc	cMin
	cpi	cMin,60 
	brne	mm1
	clr	cMin ; =60,   
mm1:         
		ldi 	r28,Mh ;   - hex
		st	Y,cMin	
		mov temp,cMin
		rcall	bin2bcd8 ; hex-dec
		ldi 	r28,DdM ;   - dec
		st	Y+,temp1	
		st	Y,temp	
	cpi	cMin,0 ;=0 -  
	brne	mmcontinue
	inc	cHour 
	cpi	cHour,24 
	brne	mm2
	clr	cHour ;  =24 - 
mm2:	ldi 	r28,Hh ;   - hex
		st	Y,cHour	
		mov temp,cHour
		rcall	bin2bcd8 ; hex-dec
		ldi 	r28,DdH ;   - dec
		st	Y+,temp1	
		st	Y,temp	
		          
mmcontinue:
reti ;TIM1	
	
TIM0:                                                                                
; 
	inc 	cRazr ; 
	cpi	cRazr,1 ; 1  -     
	brne P1 ;  -   
    	ldi 	r28,DdH ;  -  
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2) ;   
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp ; 
     	lpm ; -   r0
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	           in	temp1,PortB     ;     D
           	andi temp1,0b11111000
	 	out PORTB,temp1
	           in	temp1,PortD
           	andi temp1,0b11100011
	 	out PORTD,temp1
	 ldi temp,1<<RazrDH
           in	temp1,PortA
           andi temp1,0b10000111
	 or temp,temp1                 
	 sbr	temp,0x40
	 out PORTA,temp   ;  . 
	rjmp rADC
P1:
	cpi	cRazr,2 ; 
	brne P2
    	ldi 	r28,DeH ;  -  
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrEH
           in	temp1,PortA
           andi temp1,0b10000111
	 or temp,temp1
	 out PORTA,temp   ; 
	rjmp rADC
P2:
	cpi	cRazr,3 ;  
	brne P3
    	ldi 	r28,DdM ;  -  
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrDM
           in	temp1,PortA
           andi temp1,0b10000111
	 or temp,temp1
	 out PORTA,temp   ; 
	rjmp rADC
P3:
	cpi	cRazr,4 ; 
	brne P4
    	ldi 	r28,DeM ;  -  
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrEM
           in	temp1,PortA
           andi temp1,0b10000111
	 or temp,temp1
	 out PORTA,temp   ; 
	rjmp rADC
P4:
	cpi	cRazr,5 ; 
	brne P5
    	ldi 	r28,TdH ; Y - . 
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	           in	temp1,PortA               ;   ,  A  D
           	andi temp1,0b10000111
	 	out PORTA,temp1
	           in	temp1,PortD
           	andi temp1,0b11100011
	 	out PORTD,temp1
	 ldi temp,1<<RazrTdH
           in	temp1,PortB
           andi temp1,0b11111000
	 or temp,temp1
	 out PORTB,temp   ; 
	rjmp rADC
P5:
	cpi	cRazr,6 ; 
	brne P6
    	ldi 	r28,TdM ;  - . 
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrTdM
           in	temp1,PortB
           andi temp1,0b11111000
	 or temp,temp1
	 out PORTB,temp   ; 
	rjmp rADC
P6:
	cpi	cRazr,7 ; 
	brne P7
    	ldi 	r28,TdL ; Y - . 
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrTdL
           in	temp1,PortB
           andi temp1,0b11111000
	 or temp,temp1
	 out PORTB,temp   ; 
	rjmp rADC
P7:
	cpi	cRazr,8 ; prs
	brne P8
    	ldi 	r28,PdH ; Y -  prs
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	           in	temp1,PortA               ;   D,  A  
           	andi temp1,0b10000111
	 	out PORTA,temp1
	           in	temp1,PortB
           	andi temp1,0b11111000
	 	out PORTB,temp1
	 ldi temp,1<<RazrPdH
           in	temp1,PortD
           andi temp1,0b11100011
	 or temp,temp1
	 out PORTD,temp   ; 
	rjmp rADC
P8:	
	cpi	cRazr,9 ;	 prs
	brne P9
    	ldi 	r28,PdM ; Y -  prs
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrPdM
           in	temp1,PortD
           andi temp1,0b11100011
	 or temp,temp1
	 out PORTD,temp   ; 
	rjmp rADC
P9:
	cpi	cRazr,10 ;	 prs
	brne rADC
    	ldi 	r28,PdL ; Y -  prs
	ld	temp,Y
	ldi ZH,HIGH(OUT_N*2)
     	ldi ZL,LOW(OUT_N*2)
     	add ZL,temp
     	lpm
           in	temp1,PortC
           andi temp1,0x80
	 or r0,temp1
	out PortC,r0 ; 
	 ldi temp,1<<RazrPdL
           in	temp1,PortD
           andi temp1,0b11100011
	 or temp,temp1
	 out PORTD,temp   ; 
	clr cRazr   ; cRazr  10,   

	
rADC:	inc	countCyk   ; 
	sbrs	countCyk,5 ;  5  countCyk  1,   32   0, 
	;   (. readADC)
	reti
	clr	countCyk
	inc	count 
	cpi	count,65 ;  64 ,    
	breq endADC
	sbrc Flag,0  ;  0  -  
	ldi	temp,0
	sbrc Flag,1 ;  1  -  
	ldi	temp,1
	sbrc Flag,2 ;  2  -  
	ldi	temp,2
	out	ADMUX, temp ;    
	sbi	ADCSR,ADSC  ; .  -  
	reti

endADC:
; 
	sbrs	Flag,3 ;    
	rjmp	calcA
	sbrs	Flag,4
	rjmp	set4
	cbr	Flag,0b00010000
	cbi	PortB,5
	sbi  PortC,7 ;  
	rjmp	calcA
set4:		sbr	Flag,0b00010000
	cbi	PortC,7
	sbi	PortB,5 ; 
calcA:	;  64 
	clr	count
	sbrc Flag,0
    	ldi 	r28,Tram ;  - T
	sbrc Flag,1
    	ldi 	r28,Pram ;  - P
	sbrc Flag,2
    	ldi 	r28,Bram ;  - Bat
	ld	AregH,Y+ ;   
	ld	AregL,Y
div64L:                   ;  64
 	lsr	AregH ; 
	ror	AregL; 
	inc	count	
	cpi count,6
	brne	div64L ;-  64 
 
 	subi	r28,1  
          clr temp
     	st	Y+,temp
     	st	Y,temp ;     

bat:	sbrs Flag,2 ; 
	rjmp	tempr

	cbr	Flag,0b00001000     ; 
	mov	temp,AregH
	cpi	temp,0
	brne	ContC ; 0 -   1,25 
	cbi	PortC,7
	sbi	PortB,5 ;   0  
	rjmp	contPT
contC:	mov temp,AregL
	cpi	temp,0xAA         ;3,3 
	ldi	temp,0x02
	cpc	AregH,temp
          brsh contG
          sbr	Flag,0b00001000 ;  -  
	rjmp	contPT
	
contG:	cbi	PortB,5
	sbi  PortC,7 ; ,   
	rjmp	contPT

tempr:	sbrs Flag,0 ; 
	rjmp	prs
	    	
	    	ldi 	r28,tZH ;  
		ld	temp,Y+             
   		mov	KoeffH,temp
		ld	temp,Y
   		mov	KoeffL,temp  ;  Z 

; :
  		cp	AregL,KoeffL
  		cpc	AregH,KoeffH
  		brsh b0
 		sub	KoeffL,AregL
 		sbc	KoeffH,AregH   
 		mov	AregL,KoeffL
 		mov	AregH,KoeffH
 		sbi	PortB,6 ;  -
 		rjmp	m0
b0: ; 		
 		sub	AregL,KoeffL
 		sbc	AregH,KoeffH
 		cbi	PortB,6 ; +

m0: ;   
	    	ldi 	r28,tKH ;  
		ld	temp,Y+             
   		mov	KoeffH,temp
		ld	temp,Y
   		mov	KoeffL,temp  ; K 
                    rcall Mp16       ;
    ;   1024                   
		mov AregL,ResH
		mov AregH,temp1 ; 256
		lsr	AregH ; 
		ror	AregL; 
 		lsr	AregH ; 
		ror	AregL; ;   4
	rjmp	contPT
prs:
	sbrs Flag,1 ;  
	rjmp	contPT
	    	ldi 	r28,pZH ; 
		ld	temp,Y+             
   		mov	KoeffH,temp
		ld	temp,Y
   		mov	KoeffL,temp    ;  Z 

 		adc	AregL,KoeffL
 		add	AregH,KoeffH ;  

	    	ldi 	r28,pKH ; Y 
		ld	temp,Y+             
   		mov	KoeffH,temp
		ld	temp,Y
   		mov	KoeffL,temp    ; . K 
                    rcall Mp16     ;  
    ;  1024                 
		mov AregL,ResH
		mov AregH,temp1 ; 256
		lsr	AregH ; 
		ror	AregL; 
 		lsr	AregH ; 
		ror	AregL; ;   4

contPT: 

 	adiw	r28,5;    hex 
     	st	Y+,AregH
     	st	Y,AregL      

	sbrc Flag,0
    	ldi 	r28,TdH ;  - T
	sbrc Flag,1
    	ldi 	r28,PdH ;  - P 
	sbrc Flag,2    
	rjmp	eADC ;    ,  =2
	rcall bin2BCD16 ;   
	st	Y+,ResH  ;     BCD
	mov	temp,ResL ;    
	swap temp	
          andi	temp,0b00001111
	st	Y+,temp
	mov	temp,ResL
	andi	temp,0b00001111
	st	Y,temp ;    
	
 eADC:                
 ;      
 	clr	count
	sbrc Flag,0
	rjmp	_F0
	sbrc Flag,1
	rjmp	_F1
	cbr Flag,0x7
	sbr Flag,0x1
reti
_F0:
	cbr Flag,0x7
	sbr Flag,0x2
reti
_F1:	
	cbr Flag,0x7
	sbr Flag,0x4
reti; TIME0

readADC:    ;   
	sbrc Flag,0
    	ldi 	r28,Tram ;  - T
	sbrc Flag,1
    	ldi 	r28,Pram ;  - P
	sbrc Flag,2
    	ldi 	r28,Bram ;  - Bat
	ld	AregH,Y+
	ld	AregL,Y
	in temp1,ADCL;                    
          in temp,ADCH ;
          add	AregL,temp1 ;
          adc	AregH,temp
	dec r28
	st	Y+,AregH ; 
     	st	Y,AregL ; 
 reti ;ADC

bin2BCD16: ; 16- hex   BCD

;input: hex value low=AregL hex value high = AregH 
;output: BCD value digits 1 and 0 ResL 
;BCD value digits 2 and 3(=0) ResH
	ldi	temp1,16	;Init loop counter	
	clr	ResH		
	clr	ResL		
	clr	ZH		;clear ZH (not needed for AT90Sxx0x)
bBCDx_1:lsl	AregL		;shift input value
	rol	AregH		;through all bytes
	rol	ResL		;
	rol	ResH
	dec	temp1		;decrement loop counter
	brne	bBCDx_2		;if counter not zero
	ret			;   return
bBCDx_2:ldi	r30,AtBCD2+1	;Z points to result MSB + 1
bBCDx_3:
	ld	temp,-Z	;get (Z) with pre-decrement
	subi	temp,-$03	;add 0x03
	sbrc	temp,3	;if bit 3 not clear
	st	Z,temp	;	store back
	ld	temp,Z	;get (Z)
	subi	temp,-$30	;add 0x30
	sbrc	temp,7	;if bit 7 not clear
	st	Z,temp	;	store back
	cpi	ZL,AtBCD0	;done all three?
	brne	bBCDx_3		;loop again if not
	rjmp	bBCDx_1		

bin2bcd8: ; 8- hex   BCD
; hex= temp,  BCD  temp1-; temp - 
;        100
	clr	temp1		;clear result MSD
bBCD8_1:subi	temp,10		;input = input - 10
	brcs	bBCD8_2		;abort if carry set
	inc	temp1		;inc MSD
	rjmp	bBCD8_1		;loop again
bBCD8_2:subi	temp,-10	;compensate extra subtraction
	ret

RESET:  ;    
        cli ; 
        
      	ldi   temp,low(RAMEND) ;  
	out	SPL,temp
      	ldi   temp,high(RAMEND) ;  
	out	SPH,temp

	ldi	temp,1<<ACD	       
	out	ACSR,temp   ;. .   
	
; UART	
	ldi	temp,26 ; 9600
	out	UBRR,temp	;. 
	ldi   temp,(1<<RXEN|1<<TXEN|1<<RXB8|1<<TXB8)
	out	UCR,temp ; . / 8

;  -          
          ldi	temp,0b01111000 ;  
	out	DDRA,temp
          ldi 	temp,0b00111100 ;  
	out	DDRD,temp

	ldi	temp,0xFF ;Port7-    batt - , - 
	out	DDRC,temp
	ldi	temp,0b01111111 ;PortB6-, PortB5-    batt - , 
	;PortB0,1,2 -  ;
	out	DDRB,temp
	
	ldi	temp,0xFF
	out	TIFR,temp ;       

; 
		ldi	temp,1<<ADEN|1<<ADIE|1<<ADPS2|1<<ADPS0  ;start ADC 1/32  = 128 ; interrupt enable
	out ADCSR,temp                                    

; 
	ldi	temp, high(62968) ; 
	out	OCR1AH,temp         ;64000   1    1:64
	ldi	temp, low(62968) ; 
	out	OCR1AL,temp         ;64000   1    1:64
	ldi     temp,0b01000000
	out TCCR1A,temp ;      D5-OC1A  1
	ldi    temp,0b00001011 
	out TCCR1B,temp ;1/64 timer1; clear when compare
	ldi temp,0b00000010
	out TCCR0,temp ;Timer0 on div 1:8;  2000 

;
        	ldi	temp,(1<<TOIE0)|(1<<OCIE1A);. . T0 & T1 compare
	out	TIMSK,temp
	ldi	temp,255
	out	TIFR,temp
	out	GIFR,temp

      ;  
   	ldi 	r29,1 ;  RAM,  c 01:00
	clr	count 
	clr	cSek 
	clr	cMin 
	clr	cHour 
   	clr	countCyk
	clr	cRazr
	clr	Flag
	sbr Flag,0x1 ;  

;  
          clr temp
 	ldi 	r28,Tram ; Tempr
     	st	Y+,temp
     	st	Y,temp
 	ldi 	r28,Pram ; Prs
     	st	Y+,temp
     	st	Y,temp
 	ldi 	r28,Bram ; Batt
     	st	Y+,temp
     	st	Y,temp
	ldi 	r28,DdH	 ;  
     	st	Y+,temp
     	st	Y,temp
	ldi 	r28,DdM	 
     	st	Y+,temp
     	st	Y,temp
    	ldi 	r28,Hh ; Y 
	st	Y+, temp                 
	st	Y, temp                                                          
	
;  

 	ldi 	r28,tZH ; 
 	
; Z Tempr=461 addr=20h

 	ldi	temp,0x01 ;
     	st	Y+,temp ;
 	ldi	temp,0xCD
     	st	Y+,temp              
     	
; K Tempr=1111 addr=22h
 	ldi	temp,0x04 ;
     	st	Y+,temp
 	ldi	temp,0x57 ;
     	st	Y+,temp 
     	
; Z prs=4 addr=24h
 	ldi	temp,0x00 ;
     	st	Y+,temp
 	ldi	temp,0x04 ;
     	st	Y+,temp 

; K prs=930 addr=26h
 	ldi	temp,0x03 ;
     	st	Y+,temp
 	ldi	temp,0xA2 ;
     	st	Y,temp 

; Divisor =62968 addr=1Ah
	ldi 	r28,dQH 
  	ldi	temp,0xF5 ;
     	st	Y+,temp
 	ldi	temp,0xF8 ;
     	st	Y,temp 

sei ; 

G_cykle:           ; 
	rcall   in_com
	cpi	temp, Const_W ;A0  RAM
	breq cont_1
	cpi	temp, Const_RAM ;A3  RAM
	breq cont_4
	cpi	temp, Const_TZ ;A4   T
	breq cont_5
	cpi	temp, Const_H ;A5 ; 
	breq cont_6
	cpi	temp, Const_S0 ;A6 ;; 
	breq cont_7
	cpi	temp, Const_59 ;A7 ;   59
	breq cont_8
	cpi	temp, 0xAA ;AA ; 
	breq cont_9
      rjmp G_cykle

cont_1:	;   RAM    A0,   +   ,  
	rcall A0
rjmp G_Cykle;

cont_4: ; RAM    A3,   
	rcall A3
rjmp G_cykle

cont_5: ; 
	rcall	A4
rjmp G_cykle
                    
cont_6: ; 
	rcall	A5
rjmp G_cykle

cont_7: ; 
	rcall	A6
rjmp G_cykle

cont_8: ;   59
	rcall	A7
rjmp G_cykle

cont_9: ;AA -  
	ldi temp,0xEE
	rcall   out_com
rjmp G_cykle


A0:;A0  RAM
	cli         
	rcall   in_com 
	mov	temp1,temp;addr 
	mov	r28,temp;addr 
	rcall   in_com ;data
     	st	Y,temp ;o  

	cpi	temp1,dQL ;          
	brne	_comp
	out	OCR1AL,temp         ;64000   1    1:64
_comp:
	cpi	temp1,dQH  ;    
	brne	_out
	out	OCR1AH,temp         ;64000   1    1:64
_out:	
	ldi	temp,0xAA
	rcall   out_com
	sei                                                     
ret         

A3:; RAM                              
	cli
	rcall   in_com ;address
    	mov 	r28,temp ; Y 
	ld	temp,Y             
	rcall   out_com
	sei
ret

A4:      ; 
	cli
	clr temp;1 = -
	sbic PortB,6
	ldi temp,1
	rcall   out_com
	sei
ret	

A5: ; ,     : cMin,  addr Mh,    DdM, 
;cHour,  addr Hh,    DdH 
	cli
        	rcall   in_com ;                 
          mov	cMin,temp
        	rcall   in_com ; 
          mov	cHour,temp
    	ldi 	r28,Hh ; Y 
	st	Y+, cHour                 
	st	Y, cMin                 
		mov temp,cHour
		rcall	bin2bcd8
		ldi 	r28,DdH
		st	Y+,temp1	
		st	Y,temp	
		mov temp,cMin
		rcall	bin2bcd8
		ldi 	r28,DdM
		st	Y+,temp1	
		st	Y,temp	
	sei
ret

A6:
	clr cSek
ret

A7:
	ldi cSek,59              
ret


